"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Auth0ManagementClient = void 0;
var auth0_1 = require("auth0");
var auth0_types_1 = require("../auth0.types");
var string_1 = require("../../Lib/String/string");
var Auth0ManagementClient = /** @class */ (function () {
    function Auth0ManagementClient(_a) {
        var domain = _a.domain, clientId = _a.clientId, clientSecret = _a.clientSecret;
        var _this = this;
        this.createPasswordChangeTicket = function (_a) {
            var email = _a.email, resultUrl = _a.resultUrl, connectionId = _a.connectionId;
            return __awaiter(_this, void 0, void 0, function () {
                var response;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, this.managementClient.tickets.changePassword({
                                email: email,
                                result_url: resultUrl,
                                connection_id: connectionId,
                            })];
                        case 1:
                            response = _b.sent();
                            return [2 /*return*/, response.data.ticket];
                    }
                });
            });
        };
        this.getConnections = function (_a) {
            var _b = _a.perPage, perPage = _b === void 0 ? 50 : _b, _c = _a.page, page = _c === void 0 ? 0 : _c;
            return __awaiter(_this, void 0, void 0, function () {
                return __generator(this, function (_d) {
                    return [2 /*return*/, this.managementClient.connections.getAll({
                            include_totals: true,
                            per_page: perPage,
                            page: page,
                        })];
                });
            });
        };
        this.getAllConnections = function (_a) {
            var _b = _a.perPage, perPage = _b === void 0 ? 50 : _b, _c = _a.page, page = _c === void 0 ? 0 : _c;
            return __awaiter(_this, void 0, void 0, function () {
                var allConnections, connectionsResponse, currentPage;
                return __generator(this, function (_d) {
                    switch (_d.label) {
                        case 0:
                            allConnections = [];
                            return [4 /*yield*/, this.getConnections({
                                    perPage: perPage,
                                    page: page,
                                })];
                        case 1:
                            connectionsResponse = _d.sent();
                            allConnections = connectionsResponse.data.connections;
                            currentPage = page;
                            _d.label = 2;
                        case 2:
                            if (!(allConnections.length < connectionsResponse.data.total)) return [3 /*break*/, 4];
                            return [4 /*yield*/, this.getConnections({
                                    perPage: perPage,
                                    page: currentPage,
                                })];
                        case 3:
                            connectionsResponse = _d.sent();
                            currentPage = currentPage + perPage;
                            allConnections = __spreadArray(__spreadArray([], allConnections, true), connectionsResponse.data.connections, true);
                            return [3 /*break*/, 2];
                        case 4: return [2 /*return*/, allConnections];
                    }
                });
            });
        };
        this.isSamlConnection = function (_a) {
            var email = _a.email;
            return __awaiter(_this, void 0, void 0, function () {
                var emailDomain, connections, connectionByEmailDomain;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            emailDomain = (0, string_1.getEmailDomain)(email);
                            return [4 /*yield*/, this.getAllConnections({})];
                        case 1:
                            connections = _b.sent();
                            connectionByEmailDomain = connections.find(function (connection) { var _a, _b; return ((_b = (_a = connection === null || connection === void 0 ? void 0 : connection.options) === null || _a === void 0 ? void 0 : _a.domain_aliases) !== null && _b !== void 0 ? _b : []).includes(emailDomain); });
                            return [2 /*return*/, (connectionByEmailDomain === null || connectionByEmailDomain === void 0 ? void 0 : connectionByEmailDomain.strategy) === auth0_types_1.AuthenticationStrategy.Samlp];
                    }
                });
            });
        };
        this.managementClient = new auth0_1.ManagementClient({
            domain: domain,
            clientId: clientId,
            clientSecret: clientSecret,
        });
    }
    return Auth0ManagementClient;
}());
exports.Auth0ManagementClient = Auth0ManagementClient;
//# sourceMappingURL=Auth0ManagementClient.js.map