"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.enqueueMessage = exports.enqueueMessageRetryable = void 0;
var wait_1 = require("../Timer/wait");
var queueConfigurator_1 = require("./queueConfigurator");
var Debug = require("debug");
var debug = Debug('@signageos/lib:AMQP:enqueueMessage');
function enqueueMessageRetryable(amqpConnection, queueName, message, options, numberOfRetrying, delayBeforeRetry) {
    if (options === void 0) { options = {}; }
    if (numberOfRetrying === void 0) { numberOfRetrying = -1; }
    if (delayBeforeRetry === void 0) { delayBeforeRetry = 500; }
    return __awaiter(this, void 0, void 0, function () {
        var error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 7]);
                    return [4 /*yield*/, enqueueMessage(amqpConnection, queueName, message, options)];
                case 1:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 2:
                    error_1 = _a.sent();
                    if (!(numberOfRetrying !== 0)) return [3 /*break*/, 5];
                    debug("Enqueue message failed. Retry after ".concat(delayBeforeRetry, " ms"));
                    return [4 /*yield*/, (0, wait_1.default)(delayBeforeRetry)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, enqueueMessageRetryable(amqpConnection, queueName, message, options, numberOfRetrying - 1, delayBeforeRetry * 2)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 5: throw error_1;
                case 6: return [3 /*break*/, 7];
                case 7: return [2 /*return*/];
            }
        });
    });
}
exports.enqueueMessageRetryable = enqueueMessageRetryable;
function enqueueMessage(amqpConnection, queueName, message, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var connection, channel_1, error_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.pool.acquire(options.priority)];
                case 1:
                    connection = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 7, , 9]);
                    return [4 /*yield*/, connection.createConfirmChannel()];
                case 3:
                    channel_1 = _a.sent();
                    return [4 /*yield*/, (0, queueConfigurator_1.assertRejectableQueue)(channel_1, queueName, options.maxPriority)];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, new Promise(function (resolve, reject) {
                            return channel_1.sendToQueue(queueName, new Buffer(JSON.stringify(message)), { persistent: true }, function (error) {
                                return error !== null ? reject(error) : resolve();
                            });
                        })];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, amqpConnection.pool.release(connection)];
                case 6:
                    _a.sent();
                    return [3 /*break*/, 9];
                case 7:
                    error_2 = _a.sent();
                    return [4 /*yield*/, amqpConnection.pool.destroy(connection)];
                case 8:
                    _a.sent();
                    throw error_2;
                case 9: return [2 /*return*/];
            }
        });
    });
}
exports.enqueueMessage = enqueueMessage;
//# sourceMappingURL=enqueueMessage.js.map