"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareRejectedDetached = exports.prepareRejected = exports.prepareMany = exports.prepareMore = exports.deleteMore = exports.purgeOne = exports.waitSynchronized = exports.bindOneExpectingConfirmation = exports.bindOne = exports.fetchOneRejectedDetached = exports.bindRejectedDetached = exports.fetchOneRejected = exports.bindRejectedMany = exports.bindMany = exports.bindMore = exports.fetchAll = exports.fetchNext = exports.enqueueToConsumer = exports.enqueueNotification = exports.enqueue = void 0;
var fetchNextMessage_1 = require("../fetchNextMessage");
var deferred_1 = require("../../Promise/deferred");
var generator_1 = require("../../Hash/generator");
var ChannelProvider_1 = require("../ChannelProvider");
var EXCHANGE_PREFIX = 'events';
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
var EXCHANGE_NOTIFICATIONS_PREFIX = 'events_notifications';
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
var SYNCHRONIZATION_EXCHANGE_PREFIX = 'events_sync';
/** Alternate exchange for events (currently unused) */
var FAILED_EXCHANGE_NAME = 'events_failed';
/** Rejected exchange for (currently bindMany only) queues */
var REJECTED_EXCHANGE_NAME = 'events_rejected';
var OPTIONS = {
    persistent: true,
    confirmable: true,
    prefetchCount: 1,
};
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
var SYNCHRONIZATION_CONSUME_OPTIONS = {
    durable: false,
    exclusive: true,
    autoDelete: true,
    queueExpiresMs: 30e3, // remove after 30s when there are no consumers
};
var createEnqueueChannel = function (amqpConnection, event, exchangeName) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(event.type, OPTIONS)];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct')];
            case 2:
                _a.sent();
                return [4 /*yield*/, channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME })];
            case 3:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindChannel = function (amqpConnection, eventType, exchangeName, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType, __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct')];
            case 2:
                _a.sent();
                return [4 /*yield*/, channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME })];
            case 3:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindManyChannel = function (amqpConnection, eventTypes, domainName, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel, _i, eventTypes_1, eventType, exchangeName;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(domainName, __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(FAILED_EXCHANGE_NAME, 'direct')];
            case 2:
                _a.sent();
                _i = 0, eventTypes_1 = eventTypes;
                _a.label = 3;
            case 3:
                if (!(_i < eventTypes_1.length)) return [3 /*break*/, 6];
                eventType = eventTypes_1[_i];
                exchangeName = getExchangeName(options, eventType);
                return [4 /*yield*/, channel.assertExchange(exchangeName, 'fanout', { alternateExchange: FAILED_EXCHANGE_NAME })];
            case 4:
                _a.sent();
                _a.label = 5;
            case 5:
                _i++;
                return [3 /*break*/, 3];
            case 6: return [2 /*return*/, channel];
        }
    });
}); }; };
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
var createSynchronizationChannel = function (amqpConnection, eventType, synchronizationExchangeName) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType, OPTIONS)];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(synchronizationExchangeName, 'direct')];
            case 2:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindRejectedChannel = function (amqpConnection, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(REJECTED_EXCHANGE_NAME, __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                return [4 /*yield*/, channel.assertExchange(REJECTED_EXCHANGE_NAME, 'topic')];
            case 2:
                _a.sent();
                return [2 /*return*/, channel];
        }
    });
}); }; };
var createBindRejectedDetachedChannel = function (amqpConnection, options) { return function () { return __awaiter(void 0, void 0, void 0, function () {
    var channel;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel('default', __assign(__assign({}, OPTIONS), { prefetchCount: options.prefetchCount || OPTIONS.prefetchCount }))];
            case 1:
                channel = _a.sent();
                // currently uses default exchange
                return [2 /*return*/, channel];
        }
    });
}); }; };
function enqueue(amqpConnection, event, messageOptions) {
    if (messageOptions === void 0) { messageOptions = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName({ notification: false }, event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createEnqueueChannel(amqpConnection, event, exchangeName), event, undefined, exchangeName, getBasicEventRoutingKey(event.type), messageOptions)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.enqueue = enqueue;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function enqueueNotification(amqpConnection, event) {
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName({ notification: true }, event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createEnqueueChannel(amqpConnection, event, exchangeName), event, undefined, exchangeName, getBasicEventRoutingKey(event.type), { persistent: false })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.enqueueNotification = enqueueNotification;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function enqueueSynchronized(amqpConnection, event, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getSynchronizationExchangeName(event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createSynchronizationChannel(amqpConnection, event.type, exchangeName), event, undefined, exchangeName, getSynchronizationEventRoutingKey(consumerType, event.commandId), { persistent: false })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function enqueueToConsumer(amqpConnection, event, consumerType, eventTypeOrDomainName, messageOptions) {
    if (messageOptions === void 0) { messageOptions = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var queueName;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getQueueName(consumerType, eventTypeOrDomainName !== null && eventTypeOrDomainName !== void 0 ? eventTypeOrDomainName : event.type);
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(function () { return __awaiter(_this, void 0, void 0, function () {
                            var channel;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(event.type, OPTIONS)];
                                    case 1:
                                        channel = _a.sent();
                                        return [2 /*return*/, channel];
                                }
                            });
                        }); }, event, undefined, '', // default will auto route to queue with same name as routing key
                        queueName, // routingKey equal to queueName (specific consumer only)
                        messageOptions)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.enqueueToConsumer = enqueueToConsumer;
function fetchNext(amqpConnection, eventType, consumerType, bindOptions, queueOptions, domainName) {
    if (bindOptions === void 0) { bindOptions = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName, queueName, options;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName(bindOptions, eventType);
                    queueName = getQueueName(consumerType, eventType);
                    options = __assign(__assign(__assign({}, queueOptions), bindOptions), (domainName ? getDomainConsumeOptions(bindOptions, consumerType, domainName) : getConsumeOptionsByBindOptions(bindOptions)));
                    return [4 /*yield*/, (0, fetchNextMessage_1.default)(amqpConnection, queueName, getBasicEventRoutingKey(eventType), exchangeName, FAILED_EXCHANGE_NAME, options, 'fanout', 'direct')];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.fetchNext = fetchNext;
function fetchAll(amqpConnection, eventType, consumerType, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var eventsCaught, doNext, event_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    eventsCaught = [];
                    doNext = false;
                    _a.label = 1;
                case 1: return [4 /*yield*/, fetchNext(amqpConnection, eventType, consumerType, options)];
                case 2:
                    event_1 = _a.sent();
                    if (event_1) {
                        doNext = true;
                        eventsCaught.push(event_1);
                    }
                    else {
                        doNext = false;
                    }
                    _a.label = 3;
                case 3:
                    if (doNext) return [3 /*break*/, 1];
                    _a.label = 4;
                case 4: return [2 /*return*/, eventsCaught];
            }
        });
    });
}
exports.fetchAll = fetchAll;
/**
 * @deprecated Use bindMany instead.
 * This methods only calls bindOne function for every eventType.
 * If you'd like to compose consumption of more event types into one queue, see the bindMany instead.
 */
function bindMore(amqpConnection, eventTypes, consumerType, onEvent, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var _i, eventTypes_2, eventType;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, eventTypes_2 = eventTypes;
                    _a.label = 1;
                case 1:
                    if (!(_i < eventTypes_2.length)) return [3 /*break*/, 4];
                    eventType = eventTypes_2[_i];
                    return [4 /*yield*/, bindOne(amqpConnection, eventType, consumerType, onEvent, options)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.bindMore = bindMore;
/**
 * Bind more event types into one single queue.
 * This queue name contains specified domainName and is prefixed by consumerType.
 */
function bindMany(amqpConnection, eventTypes, domainName, consumerType, onEvent, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var queueName, bindings, consumeOptions;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getQueueName(consumerType, domainName);
                    bindings = eventTypes.map(function (eventType) {
                        var exchangeName = getExchangeName(options, eventType);
                        return { exchangeName: exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true };
                    });
                    consumeOptions = getDomainConsumeOptions(options, consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindManyChannel(amqpConnection, eventTypes, domainName, options), queueName, bindings, function (event) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, onEvent(event)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, enqueueSynchronized(amqpConnection, event, consumerType)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }, consumeOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindMany = bindMany;
/**
 * Bind all events which were rejected with enqueue=false by bindMany function (the domain type only).
 */
function bindRejectedMany(amqpConnection, domainName, consumerType, onEvent, redeliverOptions, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var queueName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedManyQueueName(consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindRejectedChannel(amqpConnection, options), queueName, [{ exchangeName: REJECTED_EXCHANGE_NAME, routingKey: getRejectedDomainRoutingKey(consumerType, domainName), persistent: true }], onEvent, getRejectedManyConsumeOptions(options, consumerType, domainName, redeliverOptions))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindRejectedMany = bindRejectedMany;
/**
 * Fetch on event which were rejected with enqueue=false by bindMany function (the domain type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
function fetchOneRejected(amqpConnection, domainName, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var queueName, connection, channel, finish, message, event, originalQueueName, domain;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedManyQueueName(consumerType, domainName);
                    return [4 /*yield*/, amqpConnection.pool.acquire()];
                case 1:
                    connection = _a.sent();
                    return [4 /*yield*/, connection.createConfirmChannel()];
                case 2:
                    channel = _a.sent();
                    finish = function () { return __awaiter(_this, void 0, void 0, function () {
                        var error_1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 3, , 5]);
                                    return [4 /*yield*/, channel.close()];
                                case 1:
                                    _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.release(connection)];
                                case 2:
                                    _a.sent();
                                    return [3 /*break*/, 5];
                                case 3:
                                    error_1 = _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.destroy(connection)];
                                case 4:
                                    _a.sent();
                                    throw error_1;
                                case 5: return [2 /*return*/];
                            }
                        });
                    }); };
                    return [4 /*yield*/, channel.get(queueName)];
                case 3:
                    message = _a.sent();
                    if (!!message) return [3 /*break*/, 5];
                    return [4 /*yield*/, finish()];
                case 4:
                    _a.sent();
                    return [2 /*return*/, null];
                case 5:
                    event = amqpConnection.channelProvider.decodeMessageBuffer(message.content);
                    originalQueueName = message.properties.headers['x-first-death-queue'];
                    if (!!originalQueueName) return [3 /*break*/, 7];
                    return [4 /*yield*/, finish()];
                case 6:
                    _a.sent();
                    throw new Error("Message is missing original queue name \"x-first-death-queue\"");
                case 7:
                    domain = parseQueueName(consumerType, originalQueueName);
                    return [2 /*return*/, {
                            event: event,
                            domain: domain,
                            ack: function () {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.ack(message);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            nack: function (nackOptions) {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.nack(message, undefined, nackOptions === null || nackOptions === void 0 ? void 0 : nackOptions.requeue);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                        }];
            }
        });
    });
}
exports.fetchOneRejected = fetchOneRejected;
/**
 * Bind one event which were rejected with enqueue=false by bindOne function (the detached type only).
 */
function bindRejectedDetached(amqpConnection, eventType, consumerType, onEvent, redeliverOptions, bindOptions) {
    if (bindOptions === void 0) { bindOptions = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var queueName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedDetachedQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindRejectedDetachedChannel(amqpConnection, bindOptions), queueName, [
                            { exchangeName: '', routingKey: queueName, persistent: true }, // this is default binding defined by AMQP protocol
                        ], onEvent, getRejectedDetachedConsumeOptions(bindOptions, consumerType, eventType, redeliverOptions))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindRejectedDetached = bindRejectedDetached;
/**
 * Fetch on event which were rejected with enqueue=false by bindOne function (the detached type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
function fetchOneRejectedDetached(amqpConnection, eventType, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var queueName, connection, channel, finish, message, event;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getRejectedDetachedQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.pool.acquire()];
                case 1:
                    connection = _a.sent();
                    return [4 /*yield*/, connection.createConfirmChannel()];
                case 2:
                    channel = _a.sent();
                    finish = function () { return __awaiter(_this, void 0, void 0, function () {
                        var error_2;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    _a.trys.push([0, 3, , 5]);
                                    return [4 /*yield*/, channel.close()];
                                case 1:
                                    _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.release(connection)];
                                case 2:
                                    _a.sent();
                                    return [3 /*break*/, 5];
                                case 3:
                                    error_2 = _a.sent();
                                    return [4 /*yield*/, amqpConnection.pool.destroy(connection)];
                                case 4:
                                    _a.sent();
                                    throw error_2;
                                case 5: return [2 /*return*/];
                            }
                        });
                    }); };
                    return [4 /*yield*/, channel.get(queueName)];
                case 3:
                    message = _a.sent();
                    if (!!message) return [3 /*break*/, 5];
                    return [4 /*yield*/, finish()];
                case 4:
                    _a.sent();
                    return [2 /*return*/, null];
                case 5:
                    event = amqpConnection.channelProvider.decodeMessageBuffer(message.content);
                    return [2 /*return*/, {
                            event: event,
                            ack: function () {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.ack(message);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                            nack: function (nackOptions) {
                                return __awaiter(this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                channel.nack(message, undefined, nackOptions === null || nackOptions === void 0 ? void 0 : nackOptions.requeue);
                                                return [4 /*yield*/, finish()];
                                            case 1:
                                                _a.sent();
                                                return [2 /*return*/];
                                        }
                                    });
                                });
                            },
                        }];
            }
        });
    });
}
exports.fetchOneRejectedDetached = fetchOneRejectedDetached;
function bindOne(amqpConnection, eventType, consumerType, onEvent, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName, queueName;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName(options, eventType);
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createBindChannel(amqpConnection, eventType, exchangeName, options), queueName, [{ exchangeName: exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true }], function (event) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, onEvent(event)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, enqueueSynchronized(amqpConnection, event, consumerType)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }, getConsumeOptionsByBindOptions(options))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindOne = bindOne;
function bindOneExpectingConfirmation(amqpConnection, eventType, consumerType, onEvent, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var exchangeName, queueName;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exchangeName = getExchangeName(options, eventType);
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(createBindChannel(amqpConnection, eventType, exchangeName, options), queueName, [{ exchangeName: exchangeName, routingKey: getBasicEventRoutingKey(eventType), persistent: true }], function (event, _headers, ack, nack) { return __awaiter(_this, void 0, void 0, function () {
                            var ackWithSync;
                            var _this = this;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        ackWithSync = function () { return __awaiter(_this, void 0, void 0, function () {
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0: return [4 /*yield*/, enqueueSynchronized(amqpConnection, event, consumerType)];
                                                    case 1:
                                                        _a.sent();
                                                        ack();
                                                        return [2 /*return*/];
                                                }
                                            });
                                        }); };
                                        return [4 /*yield*/, onEvent(event, ackWithSync, nack)];
                                    case 1:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }, getConsumeOptionsByBindOptions(options))];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindOneExpectingConfirmation = bindOneExpectingConfirmation;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
function waitSynchronized(amqpConnection, eventType, consumerType, commandId) {
    return __awaiter(this, void 0, void 0, function () {
        var deferred, exchangeName, queueName, cancelSubscription;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    deferred = (0, deferred_1.createDeferred)();
                    exchangeName = getSynchronizationExchangeName(eventType);
                    queueName = generateSynchronizationQueueName(consumerType, eventType, commandId);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(createSynchronizationChannel(amqpConnection, eventType, exchangeName), queueName, [{ exchangeName: exchangeName, routingKey: getSynchronizationEventRoutingKey(consumerType, commandId), persistent: false }], function (event) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                deferred.resolve(event);
                                return [2 /*return*/];
                            });
                        }); }, SYNCHRONIZATION_CONSUME_OPTIONS)];
                case 1:
                    cancelSubscription = _a.sent();
                    return [2 /*return*/, {
                            promise: deferred.promise,
                            cancelSubscription: cancelSubscription,
                        }];
            }
        });
    });
}
exports.waitSynchronized = waitSynchronized;
function purgeOne(amqpConnection, eventType, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var queueName, channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType)];
                case 1:
                    channel = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 4, 6]);
                    return [4 /*yield*/, channel.purge(queueName)];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 6];
                case 4: return [4 /*yield*/, channel.close()];
                case 5:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 6: return [2 /*return*/];
            }
        });
    });
}
exports.purgeOne = purgeOne;
function deleteMore(amqpConnection, eventTypes, consumerType) {
    return __awaiter(this, void 0, void 0, function () {
        var _i, eventTypes_3, eventType, queueName, channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, eventTypes_3 = eventTypes;
                    _a.label = 1;
                case 1:
                    if (!(_i < eventTypes_3.length)) return [3 /*break*/, 8];
                    eventType = eventTypes_3[_i];
                    queueName = getQueueName(consumerType, eventType);
                    return [4 /*yield*/, amqpConnection.channelProvider.getChannel(eventType)];
                case 2:
                    channel = _a.sent();
                    _a.label = 3;
                case 3:
                    _a.trys.push([3, , 5, 7]);
                    return [4 /*yield*/, channel.delete(queueName)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 5: return [4 /*yield*/, channel.close()];
                case 6:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 7:
                    _i++;
                    return [3 /*break*/, 1];
                case 8: return [2 /*return*/];
            }
        });
    });
}
exports.deleteMore = deleteMore;
function prepareMore(amqpConnection, events, consumerType, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var _i, events_1, event_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, events_1 = events;
                    _a.label = 1;
                case 1:
                    if (!(_i < events_1.length)) return [3 /*break*/, 4];
                    event_2 = events_1[_i];
                    // Hack to create event queue for exchange
                    return [4 /*yield*/, fetchNext(amqpConnection, event_2, consumerType, options)];
                case 2:
                    // Hack to create event queue for exchange
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.prepareMore = prepareMore;
function prepareMany(amqpConnection, events, domainName, consumerType, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var cancel, close;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, bindMany(amqpConnection, events, domainName, consumerType, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(function () { return undefined; })];
                    }); }); }, options)];
                case 1:
                    cancel = _a.sent();
                    return [4 /*yield*/, cancel()];
                case 2:
                    close = _a.sent();
                    return [4 /*yield*/, close()];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.prepareMany = prepareMany;
function prepareRejected(amqpConnection, domainName, consumerType, redeliverOptions, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var cancel, close;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, bindRejectedMany(amqpConnection, domainName, consumerType, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(function () { return undefined; })];
                    }); }); }, redeliverOptions, options)];
                case 1:
                    cancel = _a.sent();
                    return [4 /*yield*/, cancel()];
                case 2:
                    close = _a.sent();
                    return [4 /*yield*/, close()];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.prepareRejected = prepareRejected;
function prepareRejectedDetached(amqpConnection, eventType, consumerType, redeliverOptions, bindOptions) {
    if (bindOptions === void 0) { bindOptions = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var cancel, close;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, bindRejectedDetached(amqpConnection, eventType, consumerType, function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                        return [2 /*return*/, new Promise(function () { return undefined; })];
                    }); }); }, redeliverOptions, bindOptions)];
                case 1:
                    cancel = _a.sent();
                    return [4 /*yield*/, cancel()];
                case 2:
                    close = _a.sent();
                    return [4 /*yield*/, close()];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.prepareRejectedDetached = prepareRejectedDetached;
function getDomainConsumeOptions(options, consumerType, domainName) {
    return __assign(__assign({}, getConsumeOptionsByBindOptions(options)), { deadLetterExchange: REJECTED_EXCHANGE_NAME, deadLetterRoutingKey: getRejectedDomainRoutingKey(consumerType, domainName) });
}
function getRejectedManyConsumeOptions(bindOptions, consumerType, domainName, redeliverOptions) {
    var queueName = getQueueName(consumerType, domainName);
    return __assign(__assign({}, getConsumeOptionsByBindOptions(bindOptions)), { deadLetterExchange: '', deadLetterRoutingKey: queueName, messageExpiresMs: redeliverOptions.redeliverDelayMs, queueType: 'classic' });
}
function getRejectedDetachedConsumeOptions(bindOptions, consumerType, eventType, redeliverOptions) {
    var queueName = getQueueName(consumerType, eventType);
    return __assign(__assign({}, getConsumeOptionsByBindOptions(bindOptions)), { deadLetterExchange: '', deadLetterRoutingKey: queueName, messageExpiresMs: redeliverOptions.redeliverDelayMs, queueType: 'classic' });
}
function getConsumeOptionsByBindOptions(options) {
    return {
        autoDelete: typeof options.persistent !== 'undefined' ? !options.persistent : false,
        exclusive: typeof options.exclusive !== 'undefined' ? options.exclusive : false,
        redeliverDelayMs: typeof options.redeliverDelayMs !== 'undefined' ? options.redeliverDelayMs : 1e3,
        suppressFirstError: typeof options.suppressFirstError !== 'undefined' ? options.suppressFirstError : true,
        singleActiveConsumer: options.singleActiveConsumer,
        deadLetterIfRedeliveredAndErred: options.deadLetterIfRedeliveredAndErred,
        queueType: typeof options.queueType !== 'undefined' ? options.queueType : 'quorum', // default for event queues are swapped
    };
}
function getExchangeName(options, eventType) {
    var prefix = options.notification ? EXCHANGE_NOTIFICATIONS_PREFIX : EXCHANGE_PREFIX;
    return "".concat(prefix, "-").concat(eventType);
}
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
function getSynchronizationExchangeName(eventType) {
    return "".concat(SYNCHRONIZATION_EXCHANGE_PREFIX, "-").concat(eventType);
}
function getQueueName(consumerType, eventTypeOrDomainName) {
    return consumerType + '_' + eventTypeOrDomainName;
}
function parseQueueName(consumerType, queueName) {
    var eventTypeOrDomainName = queueName.substring(consumerType.length + 1);
    var expectedQueueName = getQueueName(consumerType, eventTypeOrDomainName);
    if (expectedQueueName !== queueName) {
        throw new Error("Incorrect queue name cannot be parsed: ".concat(consumerType, ", ").concat(queueName));
    }
    return eventTypeOrDomainName;
}
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
function generateSynchronizationQueueName(consumerType, eventType, commandId) {
    return '_synchronization_' + consumerType + '_' + eventType + '_' + commandId + '_' + (0, generator_1.generateUniqueHash)(6);
}
function getRejectedManyQueueName(consumerType, domainName) {
    return 'events_rejected.' + getQueueName(consumerType, domainName);
}
function getRejectedDetachedQueueName(consumerType, eventType) {
    return ChannelProvider_1.REJECTED_QUEUE_PREFIX + getQueueName(consumerType, eventType);
}
function escapeEventTypeForRoutingKey(eventType) {
    return eventType.replace(/\./g, '_');
}
function escapeConsumerTypeForRoutingKey(consumerType) {
    return consumerType.replace(/\./g, '_');
}
function getBasicEventRoutingKey(eventType) {
    return 'event.' + escapeEventTypeForRoutingKey(eventType);
}
/** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
function getSynchronizationEventRoutingKey(consumerType, commandId) {
    return 'event_sync.' + escapeConsumerTypeForRoutingKey(consumerType) + '.' + commandId;
}
function getRejectedDomainRoutingKey(consumerType, domainName) {
    return 'domain.' + consumerType + '.' + domainName;
}
//# sourceMappingURL=eventQueue.js.map