import IEvent, { IEventPayload } from '../IEvent';
export type EventCallback<TPayload extends IEventPayload> = (event: IEvent<TPayload>) => Promise<void>;
/**
 * High level abstraction of event consumption
 */
export interface IEventConsumer {
    /** Add a consumer for a specific event type */
    addEventConsumer<TPayload extends IEventPayload>(eventType: string, callback: EventCallback<TPayload>): void;
}
