"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareAll = exports.deleteAll = exports.purgeAll = exports.fetchNextAggregatedCommand = exports.bindAggregatedCommands = exports.markAggregatedCommandFailed = exports.markAggregatedCommandSucceeded = exports.fetchNextStoredCommand = exports.bindStoredCommands = exports.createStoredCommand = exports.AGGREGATED_QUEUE_NAME = exports.STORED_QUEUE_NAME = void 0;
var fetchNextMessage_1 = require("../fetchNextMessage");
exports.STORED_QUEUE_NAME = 'stored_commands';
exports.AGGREGATED_QUEUE_NAME = 'aggregated_commands';
var OPTIONS = {
    persistent: true,
    confirmable: false,
};
var MESSAGE_OPTIONS = {
    persistent: false, // messages are not written to disc
};
function createStoredCommand(amqpConnection, command) {
    return __awaiter(this, void 0, void 0, function () {
        var createChannel;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    createChannel = function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME, OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.STORED_QUEUE_NAME, 'fanout')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); };
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createChannel, command, undefined, exports.STORED_QUEUE_NAME, exports.STORED_QUEUE_NAME, MESSAGE_OPTIONS)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.createStoredCommand = createStoredCommand;
function bindStoredCommands(amqpConnection, onCommand) {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeRepeatable(function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME, OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.STORED_QUEUE_NAME, 'fanout')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); }, exports.STORED_QUEUE_NAME, [{ exchangeName: exports.STORED_QUEUE_NAME, routingKey: exports.STORED_QUEUE_NAME, persistent: true }], onCommand, { autoDelete: false, durable: false })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindStoredCommands = bindStoredCommands;
function fetchNextStoredCommand(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, fetchNextMessage_1.default)(amqpConnection, exports.STORED_QUEUE_NAME, exports.STORED_QUEUE_NAME, exports.STORED_QUEUE_NAME, undefined, undefined, 'fanout')];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.fetchNextStoredCommand = fetchNextStoredCommand;
function markAggregatedCommandSucceeded(amqpConnection, command, succeededAt) {
    return __awaiter(this, void 0, void 0, function () {
        var createChannel, aggregatedCommand;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    createChannel = function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.AGGREGATED_QUEUE_NAME, OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.AGGREGATED_QUEUE_NAME, 'fanout')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); };
                    aggregatedCommand = {
                        commandId: command.id,
                        succeededAt: succeededAt,
                    };
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createChannel, aggregatedCommand, undefined, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, MESSAGE_OPTIONS)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.markAggregatedCommandSucceeded = markAggregatedCommandSucceeded;
function markAggregatedCommandFailed(amqpConnection, command, failedAt, error) {
    return __awaiter(this, void 0, void 0, function () {
        var createChannel, aggregatedCommand;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    createChannel = function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.AGGREGATED_QUEUE_NAME, OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.AGGREGATED_QUEUE_NAME, 'fanout')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); };
                    aggregatedCommand = {
                        commandId: command.id,
                        failedAt: failedAt,
                        error: error,
                    };
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createChannel, aggregatedCommand, undefined, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, MESSAGE_OPTIONS)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.markAggregatedCommandFailed = markAggregatedCommandFailed;
function bindAggregatedCommands(amqpConnection, onCommand) {
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.AGGREGATED_QUEUE_NAME, OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.AGGREGATED_QUEUE_NAME, 'fanout')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); }, exports.AGGREGATED_QUEUE_NAME, [{ exchangeName: exports.AGGREGATED_QUEUE_NAME, routingKey: exports.AGGREGATED_QUEUE_NAME, persistent: true }], function (aggregatedCommand, _headers, ack, nack) {
                        return onCommand(aggregatedCommand, ack, nack);
                    }, { autoDelete: false, durable: false })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindAggregatedCommands = bindAggregatedCommands;
function fetchNextAggregatedCommand(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, fetchNextMessage_1.default)(amqpConnection, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, exports.AGGREGATED_QUEUE_NAME, undefined, undefined, 'fanout')];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.fetchNextAggregatedCommand = fetchNextAggregatedCommand;
function purgeAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME)];
                case 1:
                    channel = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 5, 7]);
                    return [4 /*yield*/, channel.purge(exports.STORED_QUEUE_NAME)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, channel.purge(exports.AGGREGATED_QUEUE_NAME)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 5: return [4 /*yield*/, channel.close()];
                case 6:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    });
}
exports.purgeAll = purgeAll;
function deleteAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.STORED_QUEUE_NAME)];
                case 1:
                    channel = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 5, 7]);
                    return [4 /*yield*/, channel.delete(exports.STORED_QUEUE_NAME)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, channel.delete(exports.AGGREGATED_QUEUE_NAME)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 5: return [4 /*yield*/, channel.close()];
                case 6:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    });
}
exports.deleteAll = deleteAll;
function prepareAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: 
                // Hack to create event queue for exchange
                return [4 /*yield*/, fetchNextStoredCommand(amqpConnection)];
                case 1:
                    // Hack to create event queue for exchange
                    _a.sent();
                    return [4 /*yield*/, fetchNextAggregatedCommand(amqpConnection)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.prepareAll = prepareAll;
//# sourceMappingURL=storedCommandQueue.js.map