/**
 * We use explicitly only 3 NODE_ENVs
 * On other environments like experimental, staging or demo is used production environment
 */
export declare enum NodeEnvironments {
    /** @deprecated use Development instead */
    Dev = "dev",
    Development = "development",
    Test = "test",
    Production = "production"
}
/**
 * @nodeEnv should be ideally process.env.NODE_ENV
 *
 * This validation method is mainly intended for validation of the env for zod
 *
 * Example usage:
 * ```
 * auth0_test_domain: z
 * 	.string()
 * 	.optional()
 * 	.refine(
 * 		(value) =>
 * 			isValidForEnvironment({
 * 				nodeEnv: process.env.NODE_ENV,
 * 				expectedEnvironment: NodeEnvironments.Test,
 * 				value,
 * 			}),
 * 		{
 * 			message: `Variable auth0_test_domain is required for ${NodeEnvironments.Test} environment.`,
 * 		},
 * 	)
 * ```
 */
export declare const isValidForEnvironment: ({ nodeEnv, expectedEnvironment, value, }: {
    nodeEnv: string | undefined;
    expectedEnvironment: NodeEnvironments;
    value: string | undefined;
}) => boolean;
