import { z } from 'zod';
/**
 * Types of emails that we can send
 *
 * The meaning of this is to separate the different types of emails but it doesn't imply any specific content.
 * There can be multiple types of content for the same type of email based on the context.
 *
 * For example, we will send a slightly different invite email in these 2 cases:
 *  - user who's email address falls under a SAML domain
 *  - other users
 * Both of these email will still be "invite" email even if their content is different.
 */
export declare enum EmailType {
    Alert = "alert",
    DeviceAlert = "device_alert",
    Intro = "introduction",
    Invite = "invite",
    PasswordReset = "password_reset",
    Welcome = "welcome",
    Unknown = ""
}
export declare const EmailTypeSchema: z.ZodNativeEnum<typeof EmailType>;
