import { z } from 'zod';
export declare const TagUidsArray: z.ZodArray<z.ZodString, "many">;
export declare const DeviceFilterSchema: z.ZodObject<{
    search: z.ZodOptional<z.ZodString>;
    organizationUid: z.ZodOptional<z.ZodString>;
    firmwareVersion: z.ZodOptional<z.ZodString>;
    applicationType: z.ZodOptional<z.ZodString>;
    identityHash: z.ZodOptional<z.ZodString>;
    identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    accountId: z.ZodOptional<z.ZodNumber>;
    applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    firmwareType: z.ZodOptional<z.ZodString>;
    serialNumber: z.ZodOptional<z.ZodString>;
    minStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
    maxStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
    bannedSince: z.ZodOptional<z.ZodDate>;
    policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    createdSince: z.ZodOptional<z.ZodDate>;
    createdUntil: z.ZodOptional<z.ZodDate>;
    filterModelName: z.ZodOptional<z.ZodString>;
    appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    orFilter: z.ZodOptional<z.ZodObject<{
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        /**
         * Each array inside array should represent group of tag and its children.
         * This argument allows to include all devices that have at least one tag from each family tree.
         */
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strict", z.ZodTypeAny, {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    }, {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    }>>;
    hasPolicy: z.ZodOptional<z.ZodBoolean>;
    tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
    locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strict", z.ZodTypeAny, {
    search?: string | undefined;
    organizationUid?: string | undefined;
    firmwareVersion?: string | undefined;
    applicationType?: string | undefined;
    identityHash?: string | undefined;
    identityHashes?: string[] | undefined;
    identityHashesExclude?: string[] | undefined;
    uids?: string[] | undefined;
    uidsExclude?: string[] | undefined;
    accountId?: number | undefined;
    applicationTypes?: string[] | undefined;
    applicationTypeNotEqual?: string | undefined;
    model?: string | undefined;
    brands?: string[] | undefined;
    firmwareType?: string | undefined;
    serialNumber?: string | undefined;
    minStorageStatusPercentage?: number | undefined;
    maxStorageStatusPercentage?: number | undefined;
    bannedSince?: Date | undefined;
    policyUids?: string[] | undefined;
    createdSince?: Date | undefined;
    createdUntil?: Date | undefined;
    filterModelName?: string | undefined;
    appletUids?: string[] | undefined;
    osVersions?: string[] | undefined;
    orFilter?: {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    } | undefined;
    hasPolicy?: boolean | undefined;
    tagUids?: string[] | undefined;
    tagWithChildrenUidGroups?: string[][] | undefined;
    locationUids?: string[] | undefined;
}, {
    search?: string | undefined;
    organizationUid?: string | undefined;
    firmwareVersion?: string | undefined;
    applicationType?: string | undefined;
    identityHash?: string | undefined;
    identityHashes?: string[] | undefined;
    identityHashesExclude?: string[] | undefined;
    uids?: string[] | undefined;
    uidsExclude?: string[] | undefined;
    accountId?: number | undefined;
    applicationTypes?: string[] | undefined;
    applicationTypeNotEqual?: string | undefined;
    model?: string | undefined;
    brands?: string[] | undefined;
    firmwareType?: string | undefined;
    serialNumber?: string | undefined;
    minStorageStatusPercentage?: number | undefined;
    maxStorageStatusPercentage?: number | undefined;
    bannedSince?: Date | undefined;
    policyUids?: string[] | undefined;
    createdSince?: Date | undefined;
    createdUntil?: Date | undefined;
    filterModelName?: string | undefined;
    appletUids?: string[] | undefined;
    osVersions?: string[] | undefined;
    orFilter?: {
        tagUids?: string[] | undefined;
        tagWithChildrenUidGroups?: string[][] | undefined;
        locationUids?: string[] | undefined;
    } | undefined;
    hasPolicy?: boolean | undefined;
    tagUids?: string[] | undefined;
    tagWithChildrenUidGroups?: string[][] | undefined;
    locationUids?: string[] | undefined;
}>;
export type DeviceFilter = z.infer<typeof DeviceFilterSchema>;
