"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceTelemetryType = void 0;
/**
 * Formerly known as DeviceMonitoringType.
 * Defines all possible telemetries reported by devices.
 * Some of those items can be managed from server on the device and those should have its same named alternative DeviceSettingsType.
 * `DeviceTelemetryType` loosely corresponts with with `TelemetryConfigurationCheckInterval`
 */
var DeviceTelemetryType;
(function (DeviceTelemetryType) {
    DeviceTelemetryType["VOLUME"] = "VOLUME";
    DeviceTelemetryType["BRIGHTNESS"] = "BRIGHTNESS";
    DeviceTelemetryType["TIMERS"] = "TIMERS";
    DeviceTelemetryType["PROPRIETARY_TIMERS"] = "PROPRIETARY_TIMERS";
    DeviceTelemetryType["RESOLUTION"] = "RESOLUTION";
    DeviceTelemetryType["ORIENTATION"] = "ORIENTATION";
    DeviceTelemetryType["REMOTE_CONTROL"] = "REMOTE_CONTROL";
    DeviceTelemetryType["APPLICATION_VERSION"] = "APPLICATION_VERSION";
    DeviceTelemetryType["FIRMWARE_VERSION"] = "FIRMWARE_VERSION";
    DeviceTelemetryType["DEBUG"] = "DEBUG";
    DeviceTelemetryType["DATETIME"] = "DATETIME";
    DeviceTelemetryType["POWER_ACTIONS_SCHEDULE"] = "POWER_ACTIONS_SCHEDULE";
    DeviceTelemetryType["TEMPERATURE"] = "TEMPERATURE";
    DeviceTelemetryType["BUNDLED_APPLET"] = "BUNDLED_APPLET";
    DeviceTelemetryType["AUTO_RECOVERY"] = "AUTO_RECOVERY";
    DeviceTelemetryType["PEER_RECOVERY"] = "PEER_RECOVERY";
    DeviceTelemetryType["PROXY"] = "PROXY";
    DeviceTelemetryType["WIFI_STRENGTH"] = "WIFI_STRENGTH";
    DeviceTelemetryType["FRONT_CAPABILITIES"] = "FRONT_CAPABILITIES";
    DeviceTelemetryType["MANAGEMENT_CAPABILITIES"] = "MANAGEMENT_CAPABILITIES";
    DeviceTelemetryType["DISPLAY_SETTING"] = "DISPLAY_SETTING";
    DeviceTelemetryType["INPUT_SOURCE"] = "INPUT_SOURCE";
    DeviceTelemetryType["FRONT_DISPLAY_VERSION"] = "FRONT_DISPLAY_VERSION";
    DeviceTelemetryType["OFFLINE_RANGE"] = "OFFLINE_RANGE";
    DeviceTelemetryType["ONLINE_STATUS"] = "ONLINE_STATUS";
    DeviceTelemetryType["CONNECTION_METHOD"] = "CONNECTION_METHOD";
    DeviceTelemetryType["EXTENDED_MANAGEMENT"] = "EXTENDED_MANAGEMENT";
    DeviceTelemetryType["NETWORK_INTERFACES"] = "NETWORK_INTERFACES";
    DeviceTelemetryType["DISPLAY_POWER_ON"] = "DISPLAY_POWER_ON";
})(DeviceTelemetryType || (exports.DeviceTelemetryType = DeviceTelemetryType = {}));
