/**
 * All settings that can be set on the device. For example using policy.
 * All of them should be available as a DeviceTelemetryType with the same name as the setting.
 */
export declare enum DeviceSettingsType {
    VOLUME = "VOLUME",
    BRIGHTNESS = "BRIGHTNESS",
    TIMERS = "TIMERS",
    PROPRIETARY_TIMERS = "PROPRIETARY_TIMERS",
    RESOLUTION = "RESOLUTION",
    ORIENTATION = "ORIENTATION",
    REMOTE_CONTROL = "REMOTE_CONTROL",
    APPLICATION_VERSION = "APPLICATION_VERSION",
    FIRMWARE_VERSION = "FIRMWARE_VERSION",
    DEBUG = "DEBUG",
    DATETIME = "DATETIME",
    POWER_ACTIONS_SCHEDULE = "POWER_ACTIONS_SCHEDULE",
    TEMPERATURE = "TEMPERATURE",
    AUTO_RECOVERY = "AUTO_RECOVERY",
    PEER_RECOVERY = "PEER_RECOVERY",
    PROXY = "PROXY",
    CONNECTION_METHOD = "CONNECTION_METHOD",
    PACKAGES = "PACKAGES",
    TELEMETRY_INTERVALS = "TELEMETRY_INTERVALS",
    APPLET = "APPLET",
    EXTENDED_MANAGEMENT = "EXTENDED_MANAGEMENT",
    NETWORK_INTERFACES = "NETWORK_INTERFACES",
    DISPLAY_POWER_ON = "DISPLAY_POWER_ON"
}
