export declare enum BulkProvisioningBrand {
    Sony = "Sony",
    LG = "LG",
    Samsung = "Samsung",
    BrightSign = "BrightSign"
}
export declare enum BulkProvisioningDeviceProperty {
    SerialNumber = "serialNumber",
    Model = "model",
    MacAddress = "macAddress"
}
export type DeviceProperties = {
    [BulkProvisioningDeviceProperty.SerialNumber]: string;
    [BulkProvisioningDeviceProperty.Model]: string;
    [BulkProvisioningDeviceProperty.MacAddress]: string;
};
export declare const BulkProvisioningUniqueness: {
    [K in BulkProvisioningBrand]: (deviceProperties: DeviceProperties) => string;
};
export declare const BulkProvisioningRequiredProperties: {
    [K in BulkProvisioningBrand]: BulkProvisioningDeviceProperty[];
};
type Nullish<T> = {
    [K in keyof T]?: T[K] | null;
};
export type BulkProvisioningUniquenessType<T extends typeof BulkProvisioningUniqueness = typeof BulkProvisioningUniqueness> = {
    [K in keyof T]: T[K] extends (...args: any) => any ? (deviceProps: Nullish<Parameters<T[K]>[0]>) => ReturnType<T[K]> : never;
};
export declare const BulkProvisioningUniquenessHashMap: BulkProvisioningUniquenessType;
export declare function hashByBrand({ brand, deviceProperties, }: {
    brand: `${BulkProvisioningBrand}`;
    deviceProperties: Nullish<DeviceProperties>;
}): string;
export declare function isBrand(x: unknown): x is `${BulkProvisioningBrand}`;
export declare const BulkProvisioningBrands: BulkProvisioningBrand[];
export declare const BulkProvisioningDeviceProperties: ("SerialNumber" | "Model" | "MacAddress")[];
export declare enum BulkProvisioningRecipeProperty {
    ConfirmedOwnership = "confirmedOwnership"
}
export type RecipeProperties = {
    [BulkProvisioningRecipeProperty.ConfirmedOwnership]: boolean;
};
export declare const BulkProvisioningRecipeRequiredProperties: {
    [K in BulkProvisioningBrand]?: BulkProvisioningRecipeProperty[];
};
export {};
