import { z } from 'zod';
/**
 * List of all currently installed packages on the device.
 */
export declare const InstalledPackagesSchema: z.ZodObject<{
    /** Currently supported only for android */
    applicationType: z.ZodLiteral<"android">;
    packages: z.ZodArray<z.ZodObject<{
        buildHash: z.ZodString;
        specs: z.ZodObject<{
            packageName: z.ZodString;
            versionCode: z.ZodNumber;
            apkSha256: z.ZodString;
            versionName: z.ZodOptional<z.ZodString>;
            signatureSha256: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            packageName: string;
            versionCode: number;
            apkSha256: string;
            versionName?: string | undefined;
            signatureSha256?: string | undefined;
        }, {
            packageName: string;
            versionCode: number;
            apkSha256: string;
            versionName?: string | undefined;
            signatureSha256?: string | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        buildHash: string;
        specs: {
            packageName: string;
            versionCode: number;
            apkSha256: string;
            versionName?: string | undefined;
            signatureSha256?: string | undefined;
        };
    }, {
        buildHash: string;
        specs: {
            packageName: string;
            versionCode: number;
            apkSha256: string;
            versionName?: string | undefined;
            signatureSha256?: string | undefined;
        };
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    applicationType: "android";
    packages: {
        buildHash: string;
        specs: {
            packageName: string;
            versionCode: number;
            apkSha256: string;
            versionName?: string | undefined;
            signatureSha256?: string | undefined;
        };
    }[];
}, {
    applicationType: "android";
    packages: {
        buildHash: string;
        specs: {
            packageName: string;
            versionCode: number;
            apkSha256: string;
            versionName?: string | undefined;
            signatureSha256?: string | undefined;
        };
    }[];
}>;
export type InstalledPackages = z.infer<typeof InstalledPackagesSchema>;
