import { z } from 'zod';
export declare const AndroidDevicePackageInstallationSchema: z.ZodObject<{
    packageName: z.ZodString;
    ownerOrganizationUid: z.ZodString;
    buildHash: z.ZodString;
    version: z.ZodString;
    build: z.ZodNullable<z.ZodString>;
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodObject<{
        packageName: z.ZodString;
        sdkVersion: z.ZodNumber;
        supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
        multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
        versionCode: z.ZodOptional<z.ZodNumber>;
        targetSdkVersion: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    version: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}, {
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    version: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}>;
export type AndroidDevicePackageInstallation = z.infer<typeof AndroidDevicePackageInstallationSchema>;
export declare const DevicePackageInstallationSchema: z.ZodObject<{
    packageName: z.ZodString;
    ownerOrganizationUid: z.ZodString;
    buildHash: z.ZodString;
    version: z.ZodString;
    build: z.ZodNullable<z.ZodString>;
    applicationType: z.ZodLiteral<"android">;
    specs: z.ZodObject<{
        packageName: z.ZodString;
        sdkVersion: z.ZodNumber;
        supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
        multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
        versionCode: z.ZodOptional<z.ZodNumber>;
        targetSdkVersion: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }, {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    version: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}, {
    packageName: string;
    applicationType: "android";
    ownerOrganizationUid: string;
    buildHash: string;
    version: string;
    build: string | null;
    specs: {
        packageName: string;
        sdkVersion: number;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
}>;
export type DevicePackageInstallation = z.infer<typeof DevicePackageInstallationSchema>;
