import { z } from 'zod';
export declare const MacAddressSchema: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
/**
 * See also:
 * * https://www.thomas-krenn.com/en/wiki/Predictable_Network_Interface_Names.
 * * https://openwrt.org/docs/guide-developer/networking/network.interfaces
 */
export declare const NetworkInterfaceType: readonly ["wifi", "ethernet", "vpn", "mobile"];
export type NetworkInterfaceType = (typeof NetworkInterfaceType)[number];
/** @deprecated use singular @type {NetworkInterfaceType} */
export type NetworkInterfacesTypes = NetworkInterfaceType;
declare const WifiNetworkInterfaceSchema: z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"wifi">;
    wifiStrength: z.ZodOptional<z.ZodNumber>;
    wifiSsid: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
}, {
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
}>;
declare const EthernetNetworkInterfaceSchema: z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"ethernet">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>;
declare const VpnNetworkInterfaceSchema: z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"vpn">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>;
declare const MobileNetworkInterfaceSchema: z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"mobile">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>;
export type WifiNetwork = z.infer<typeof WifiNetworkInterfaceSchema>;
export type EthernetNetwork = z.infer<typeof EthernetNetworkInterfaceSchema>;
export type VpnNetwork = z.infer<typeof VpnNetworkInterfaceSchema>;
export type MobileNetwork = z.infer<typeof MobileNetworkInterfaceSchema>;
export declare const NetworkInterfaceSchema: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"wifi">;
    wifiStrength: z.ZodOptional<z.ZodNumber>;
    wifiSsid: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
}, {
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
}>, z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"ethernet">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>, z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"vpn">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>, z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"mobile">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>]>;
/** @deprecated use singular @type {NetworkInterfaceSchema} */
export declare const NetworkInterfacesSchema: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"wifi">;
    wifiStrength: z.ZodOptional<z.ZodNumber>;
    wifiSsid: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
}, {
    name: string;
    type: "wifi";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
    wifiStrength?: number | undefined;
    wifiSsid?: string | undefined;
}>, z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"ethernet">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "ethernet";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>, z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"vpn">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "vpn";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>, z.ZodObject<{
    name: z.ZodString;
    disabled: z.ZodOptional<z.ZodBoolean>;
    macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
    gateway: z.ZodOptional<z.ZodString>;
    localAddress: z.ZodOptional<z.ZodString>;
    netmask: z.ZodOptional<z.ZodString>;
    dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodLiteral<"mobile">;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}, {
    name: string;
    type: "mobile";
    macAddress: string;
    disabled?: boolean | undefined;
    gateway?: string | undefined;
    localAddress?: string | undefined;
    netmask?: string | undefined;
    dns?: string[] | undefined;
}>]>;
export type NetworkInterface = z.infer<typeof NetworkInterfacesSchema>;
/** @deprecated use singular @type {NetworkInterface} */
export type NetworkInterfaces = NetworkInterface;
export {};
