export type AutoRecoveryEnabled = {
    enabled: true;
    /**
     * It defines in miliseconds period whose elapsing leads to mark browser process as unresponding.
     */
    healthcheckIntervalMs: number;
};
export type AutoRecoveryDisabled = {
    enabled: false;
    /**
     * When specified it defines period until automatic enabling auto recovery process in miliseconds.
     */
    autoEnableTimeoutMs?: number;
};
export type PeerRecoveryEnabled = {
    enabled: true;
    /**
     * This URL address has to be set in URL launcher on device that is recovered.
     */
    urlLauncherAddress: string;
};
export type PeerRecoveryDisabled = {
    enabled: false;
    /**
     * When specified it defines period until automatic enabling auto recovery process in miliseconds.
     */
    autoEnableTimeoutMs?: number;
};
