"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomScriptResultSchema = exports.CustomScriptSchema = exports.CustomScriptResultBsnSchema = exports.CustomScriptResultBrowserSchema = exports.CustomScriptResultNodeJSSchema = exports.CustomScriptResultShellSchema = exports.CustomScriptResultBashSchema = exports.CustomScriptResultPowerShellSchema = exports.ResultStreamPipelineSchema = exports.CustomScriptBsnSchema = exports.CustomScriptBrowserSchema = exports.CustomScriptNodeJSSchema = exports.CustomScriptShellSchema = exports.CustomScriptBashSchema = exports.CustomScriptPowerShellSchema = exports.RuntimeSchema = exports.SCRIPT_MAX_LENGTH = void 0;
const zod_1 = require("zod");
exports.SCRIPT_MAX_LENGTH = 10e3;
exports.RuntimeSchema = zod_1.z.enum([
    /** PowerShell */
    'ps1',
    /** Bash */
    'bash',
    /** Shell */
    'sh',
    /** Node.js */
    'nodejs',
    /** Browser JS */
    'browser',
    /** BrightScript */
    'bsn',
]);
const createCustomScriptSchema = (runtime) => zod_1.z.strictObject({
    runtime: zod_1.z.literal(runtime),
    script: zod_1.z.string().max(exports.SCRIPT_MAX_LENGTH),
});
exports.CustomScriptPowerShellSchema = createCustomScriptSchema('ps1');
exports.CustomScriptBashSchema = createCustomScriptSchema('bash');
exports.CustomScriptShellSchema = createCustomScriptSchema('sh');
exports.CustomScriptNodeJSSchema = createCustomScriptSchema('nodejs');
exports.CustomScriptBrowserSchema = createCustomScriptSchema('browser');
exports.CustomScriptBsnSchema = createCustomScriptSchema('bsn');
/**
 * @see https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.utility/write-output?view=powershell-7.4
 */
exports.ResultStreamPipelineSchema = zod_1.z.enum(['error', 'output']);
const createCustomScriptResultSchema = (runtime) => zod_1.z.strictObject({
    runtime: zod_1.z.literal(runtime),
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: zod_1.z.array(zod_1.z.object({
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: exports.ResultStreamPipelineSchema,
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: zod_1.z.number().int(),
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: zod_1.z.string(),
    })),
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: zod_1.z.number().int(),
});
exports.CustomScriptResultPowerShellSchema = createCustomScriptResultSchema('ps1');
exports.CustomScriptResultBashSchema = createCustomScriptResultSchema('bash');
exports.CustomScriptResultShellSchema = createCustomScriptResultSchema('sh');
exports.CustomScriptResultNodeJSSchema = createCustomScriptResultSchema('nodejs');
exports.CustomScriptResultBrowserSchema = createCustomScriptResultSchema('browser');
exports.CustomScriptResultBsnSchema = createCustomScriptResultSchema('bsn');
// All
/**
 * Custom script to be executed on the device.
 */
exports.CustomScriptSchema = zod_1.z.discriminatedUnion('runtime', [
    exports.CustomScriptPowerShellSchema,
    exports.CustomScriptBashSchema,
    exports.CustomScriptShellSchema,
    exports.CustomScriptNodeJSSchema,
    exports.CustomScriptBrowserSchema,
    exports.CustomScriptBsnSchema,
]);
exports.CustomScriptResultSchema = zod_1.z.discriminatedUnion('runtime', [
    exports.CustomScriptResultPowerShellSchema,
    exports.CustomScriptResultBashSchema,
    exports.CustomScriptResultShellSchema,
    exports.CustomScriptResultNodeJSSchema,
    exports.CustomScriptResultBrowserSchema,
    exports.CustomScriptResultBsnSchema,
]);
