import { z } from 'zod';
export declare const SCRIPT_MAX_LENGTH = 10000;
export declare const RuntimeSchema: z.ZodEnum<["ps1", "bash", "sh", "nodejs", "browser", "bsn"]>;
export type Runtime = z.infer<typeof RuntimeSchema>;
export declare const CustomScriptPowerShellSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"ps1">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "ps1";
}, {
    script: string;
    runtime: "ps1";
}>;
export type CustomScriptPowerShell = z.infer<typeof CustomScriptPowerShellSchema>;
export declare const CustomScriptBashSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"bash">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "bash";
}, {
    script: string;
    runtime: "bash";
}>;
export type CustomScriptBash = z.infer<typeof CustomScriptBashSchema>;
export declare const CustomScriptShellSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"sh">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "sh";
}, {
    script: string;
    runtime: "sh";
}>;
export type CustomScriptShell = z.infer<typeof CustomScriptShellSchema>;
export declare const CustomScriptNodeJSSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"nodejs">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "nodejs";
}, {
    script: string;
    runtime: "nodejs";
}>;
export type CustomScriptNodeJS = z.infer<typeof CustomScriptNodeJSSchema>;
export declare const CustomScriptBrowserSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"browser">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "browser";
}, {
    script: string;
    runtime: "browser";
}>;
export type CustomScriptBrowser = z.infer<typeof CustomScriptBrowserSchema>;
export declare const CustomScriptBsnSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"bsn">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "bsn";
}, {
    script: string;
    runtime: "bsn";
}>;
export type CustomScriptBsn = z.infer<typeof CustomScriptBsnSchema>;
/**
 * @see https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.utility/write-output?view=powershell-7.4
 */
export declare const ResultStreamPipelineSchema: z.ZodEnum<["error", "output"]>;
export declare const CustomScriptResultPowerShellSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"ps1">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "ps1";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "ps1";
    exitCode: number;
}>;
export type CustomScriptResultPowerShell = z.infer<typeof CustomScriptResultPowerShellSchema>;
export declare const CustomScriptResultBashSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"bash">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bash";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bash";
    exitCode: number;
}>;
export type CustomScriptResultBash = z.infer<typeof CustomScriptResultBashSchema>;
export declare const CustomScriptResultShellSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"sh">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "sh";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "sh";
    exitCode: number;
}>;
export type CustomScriptResultShell = z.infer<typeof CustomScriptResultShellSchema>;
export declare const CustomScriptResultNodeJSSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"nodejs">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "nodejs";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "nodejs";
    exitCode: number;
}>;
export type CustomScriptResultNodeJS = z.infer<typeof CustomScriptResultNodeJSSchema>;
export declare const CustomScriptResultBrowserSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"browser">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "browser";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "browser";
    exitCode: number;
}>;
export type CustomScriptResultBrowser = z.infer<typeof CustomScriptResultBrowserSchema>;
export declare const CustomScriptResultBsnSchema: z.ZodObject<{
    runtime: z.ZodLiteral<"bsn">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bsn";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bsn";
    exitCode: number;
}>;
export type CustomScriptResultBsn = z.infer<typeof CustomScriptResultBsnSchema>;
/**
 * Custom script to be executed on the device.
 */
export declare const CustomScriptSchema: z.ZodDiscriminatedUnion<"runtime", [z.ZodObject<{
    runtime: z.ZodLiteral<"ps1">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "ps1";
}, {
    script: string;
    runtime: "ps1";
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"bash">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "bash";
}, {
    script: string;
    runtime: "bash";
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"sh">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "sh";
}, {
    script: string;
    runtime: "sh";
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"nodejs">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "nodejs";
}, {
    script: string;
    runtime: "nodejs";
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"browser">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "browser";
}, {
    script: string;
    runtime: "browser";
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"bsn">;
    script: z.ZodString;
}, "strict", z.ZodTypeAny, {
    script: string;
    runtime: "bsn";
}, {
    script: string;
    runtime: "bsn";
}>]>;
export type CustomScript = z.infer<typeof CustomScriptSchema>;
export declare const CustomScriptResultSchema: z.ZodDiscriminatedUnion<"runtime", [z.ZodObject<{
    runtime: z.ZodLiteral<"ps1">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "ps1";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "ps1";
    exitCode: number;
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"bash">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bash";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bash";
    exitCode: number;
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"sh">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "sh";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "sh";
    exitCode: number;
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"nodejs">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "nodejs";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "nodejs";
    exitCode: number;
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"browser">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "browser";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "browser";
    exitCode: number;
}>, z.ZodObject<{
    runtime: z.ZodLiteral<"bsn">;
    /**
     * The output/error stream of the script ordered chunks by the timestamp.
     */
    stream: z.ZodArray<z.ZodObject<{
        /**
         * The pipeline type of the output/error stream.
         */
        pipeline: z.ZodEnum<["error", "output"]>;
        /**
         * The exact time in milliseconds when the chunk of output/error stream was written to the console.
         * It is required to properly order the output/error stream on the target UI.
         */
        timestamp: z.ZodNumber;
        /**
         * The data chunk of the output/error stream.
         * Usually, the chunk can be single line of the output/error stream.
         */
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }, {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }>, "many">;
    /**
     * The exit code of the script when finished.
     * Usually, 0 means success, and any other value means an error.
     */
    exitCode: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bsn";
    exitCode: number;
}, {
    stream: {
        data: string;
        pipeline: "error" | "output";
        timestamp: number;
    }[];
    runtime: "bsn";
    exitCode: number;
}>]>;
export type CustomScriptResult = z.infer<typeof CustomScriptResultSchema>;
