import { z } from 'zod';
import { InputSource as CommonInputSource } from '../Device/Input/InputSource';
export declare enum DeviceActionType {
    SET_APPLICATION_VERSION = "SET_APPLICATION_VERSION",
    SET_VOLUME = "SET_VOLUME",
    SET_BRIGHTNESS = "SET_BRIGHTNESS",
    RECONNECT = "RECONNECT",
    UPDATE_CONFIGURATION = "UPDATE_CONFIGURATION",
    UPDATE_TIME = "UPDATE_TIME",
    SET_DEBUG = "SET_DEBUG",
    SET_FIRMWARE_VERSION = "SET_FIRMWARE_VERSION",
    INSTALL_PACKAGE = "INSTALL_PACKAGE",
    INSTALL_PACKAGE_FROM_URI = "INSTALL_PACKAGE_FROM_URI",
    UNINSTALL_PACKAGE = "UNINSTALL_PACKAGE",
    POWER_ACTION = "POWER_ACTION",
    SET_SCHEDULED_POWER_ACTION = "SET_SCHEDULED_POWER_ACTION",
    CANCEL_SCHEDULED_POWER_ACTION = "CANCEL_SCHEDULED_POWER_ACTION",
    SET_REMOTE_CONTROL = "SET_REMOTE_CONTROL",
    RESIZE = "RESIZE",
    PROVISION = "PROVISION",
    DEPROVISION = "DEPROVISION",
    UPDATE_NAME = "UPDATE_NAME",
    BAN = "BAN",
    APPROVE = "APPROVE",
    CHANGE_SUBSCRIPTION_TYPE = "CHANGE_SUBSCRIPTION_TYPE",
    CREATE_TIMING = "CREATE_TIMING",
    UPDATE_TIMING = "UPDATE_TIMING",
    DELETE_TIMING = "DELETE_TIMING",
    SET_POLICY = "SET_POLICY",
    DELETE_POLICY = "DELETE_POLICY",
    SET_ORGANIZATION_TAGS = "SET_ORGANIZATION_TAGS",
    DELETE_ORGANIZATION_TAGS = "DELETE_ORGANIZATION_TAGS",
    SET_ORGANIZATION = "SET_ORGANIZATION",
    SET_DEVICE_APPLET_TEST_SUITE = "SET_DEVICE_APPLET_TEST_SUITE",// aka START_DEVICE_APPLET_TEST_SUITE
    SET_TEST_SUITE = "SET_TEST_SUITE",// aka START_TEST_SUITE
    START_PACKAGE = "START_PACKAGE",
    SET_TIMER = "SET_TIMER",
    SET_PROPRIETARY_TIMER = "SET_PROPRIETARY_TIMER",
    SET_POWER_STATUS = "SET_POWER_STATUS",
    SET_INPUT_SOURCE = "SET_INPUT_SOURCE",
    SET_DISPLAY_BACKLIGHT = "SET_DISPLAY_BACKLIGHT",
    SET_DISPLAY_CONTRAST = "SET_DISPLAY_CONTRAST",
    SET_DISPLAY_SHARPNESS = "SET_DISPLAY_SHARPNESS",
    SET_DISPLAY_TEMPERATURE_CONTROL = "SET_DISPLAY_TEMPERATURE_CONTROL",
    SET_REMOTE_DESKTOP = "SET_REMOTE_DESKTOP",
    SET_AUTO_RECOVERY = "SET_AUTO_RECOVERY",
    SET_PEER_RECOVERY = "SET_PEER_RECOVERY",
    ENABLE_EXTENDED_TELEMETRY = "ENABLE_EXTENDED_TELEMETRY",
    DISABLE_EXTENDED_TELEMETRY = "DISABLE_EXTENDED_TELEMETRY",
    TELEMETRY_INTERVALS = "TELEMETRY_INTERVALS"
}
/** @deprecated Use @signageos/common-types/dist/Device/Input/InputSource */
export type InputSource = CommonInputSource;
/** @deprecated Use @signageos/common-types/dist/Device/Input/InputSource */
export declare const InputSource: typeof CommonInputSource;
export declare enum BulkOperationStatus {
    SCHEDULED = "SCHEDULED",
    IN_PROGRESS = "IN_PROGRESS",
    WAITING = "WAITING",
    PAUSED = "PAUSED",
    STOPPED = "STOPPED",
    FINISHED = "FINISHED",
    ARCHIVED = "ARCHIVED"
}
export declare const BulkOperationStatusSchema: z.ZodNativeEnum<typeof BulkOperationStatus>;
