"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidUpdateSnoozeRule = exports.InvalidSnoozeRuleDateTime = exports.InvalidSnoozeRuleType = exports.snoozeRuleTypes = void 0;
exports.default = isValidSnoozeRule;
const Validation_1 = require("../../Validation/Validation");
exports.snoozeRuleTypes = ['datetime', 'update'];
function isValidSnoozeRule(snoozeRuleInput) {
    var _a;
    const validation = (0, Validation_1.createValidation)({});
    const isValidType = typeof snoozeRuleInput === 'object';
    if (isValidType) {
        const snoozeRule = (_a = snoozeRuleInput) !== null && _a !== void 0 ? _a : {};
        if (exports.snoozeRuleTypes.includes(snoozeRule.type)) {
            switch (snoozeRule.type) {
                case 'datetime': {
                    const isValidObject = snoozeRule.snoozedUntil && snoozeRule.snoozedUntil instanceof Date;
                    if (!isValidObject) {
                        validation.addError(new InvalidSnoozeRuleDateTime(snoozeRuleInput));
                    }
                    break;
                }
                case 'update': {
                    const isValidObject = snoozeRule.type === 'update' && typeof snoozeRule.occurrencesDiff === 'number';
                    if (!isValidObject) {
                        validation.addError(new InvalidUpdateSnoozeRule(snoozeRuleInput));
                    }
                    break;
                }
            }
        }
        else {
            validation.addError(new InvalidSnoozeRuleType(snoozeRuleInput));
        }
    }
    else {
        validation.addError(new InvalidSnoozeRuleType(snoozeRuleInput));
    }
    return validation.getOutput();
}
class InvalidSnoozeRuleType extends Error {
    constructor(rule) {
        super(`Snooze rule is not valid: ${JSON.stringify(rule)}`);
    }
}
exports.InvalidSnoozeRuleType = InvalidSnoozeRuleType;
class InvalidSnoozeRuleDateTime extends Error {
    constructor(rule) {
        super(`Snooze rule is datetime is not valid: ${JSON.stringify(rule)}`);
    }
}
exports.InvalidSnoozeRuleDateTime = InvalidSnoozeRuleDateTime;
class InvalidUpdateSnoozeRule extends Error {
    constructor(rule) {
        super(`Update snooze rule is not valid: ${JSON.stringify(rule)}`);
    }
}
exports.InvalidUpdateSnoozeRule = InvalidUpdateSnoozeRule;
