"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConditionKind = exports.ConditionType = exports.AppletConditionType = exports.PolicyConditionType = exports.DeviceConditionType = void 0;
/** Device related condition types */
exports.DeviceConditionType = {
    // Special computed values
    /** Is used when device has incorrect time based on current time & timezone of device */
    INCORRECT_TIME: 'INCORRECT_TIME',
    /** Is used when device is detected having some problems with SSL certificates (it can be even time related) */
    INVALID_SSL_CERTIFICATE: 'INVALID_SSL_CERTIFICATE',
    /** Is used when device performing/executing action has failed for amount of time in past */
    FAILED_ACTIONS: 'FAILED_ACTIONS',
    /** Connection status of device. Check if device is currently connected or not. Additionally ALIVE_AT available */
    CONNECTIONS: 'CONNECTIONS',
    // Standard data of device collection
    /** Check if device has model or not */
    MODEL: 'MODEL',
    /** Check if device has serial number or not */
    SERIAL_NUMBER: 'SERIAL_NUMBER',
    /** Check if device partially match some string */
    NAME: 'NAME',
    /** Check if device has PIN code reported */
    PIN_CODE: 'PIN_CODE',
    /** Check if device match semver version */
    MANAGEMENT_PACKAGE_VERSION: 'MANAGEMENT_PACKAGE_VERSION',
    /** Check if device match semver version */
    FRONT_PACKAGE_VERSION: 'FRONT_PACKAGE_VERSION',
    /** Check if device match semver version */
    FRONT_DISPLAY_VERSION: 'FRONT_DISPLAY_VERSION',
    /** Check if device partially match some string */
    FIRMWARE_TYPE: 'FIRMWARE_TYPE',
    /** Check if device has selected tags */
    TAG_UIDS: 'TAG_UIDS',
    /** Check if device has selected policy settings */
    POLICIES: 'POLICIES',
    /** Check if device was provisioned in specified time range in past. Useful to detect new devices are provisioned */
    LAST_PROVISION_AT: 'LAST_PROVISION_AT',
    /** Check if device was deprovisioned in specified time range in past. Useful to detect devices are re-provisioned */
    LAST_DEPROVISION_AT: 'LAST_DEPROVISION_AT',
    /** Check if device has access to extended management */
    EXTENDED_MANAGEMENT: 'EXTENDED_MANAGEMENT',
    // More data of device info collection
    /** Check if device last ping in specified time range in past. */
    ALIVE_AT: 'ALIVE_AT',
    /** Check if device is connected using WiFi or Ethernet */
    NETWORK_INTERFACES: 'NETWORK_INTERFACES',
    /** Check if device has enough or not enough battery */
    BATTERY_STATUS: 'BATTERY_STATUS',
    /** Check if device has or has not enough free storage */
    STORAGE_STATUS: 'STORAGE_STATUS',
    /** Check if timezone match the string */
    CURRENT_TIMEZONE: 'CURRENT_TIMEZONE',
    // Telemetry from monitoring log
    /** Check if match expected value of display settings */
    DISPLAY_SETTING_BACKLIGHT: 'DISPLAY_SETTING_BACKLIGHT',
    DISPLAY_SETTING_CONTRAST: 'DISPLAY_SETTING_CONTRAST',
    DISPLAY_SETTING_SHARPNESS: 'DISPLAY_SETTING_SHARPNESS',
    /** mas temperature in celsius */
    DISPLAY_SETTING_MAX_TEMPERATURE: 'DISPLAY_SETTING_MAX_TEMPERATURE',
    /** Check if current input source is set to specified source */
    INPUT_SOURCE: 'INPUT_SOURCE',
    /** Check if current volume is expected */
    VOLUME: 'VOLUME',
    /** Check if current brightness is expected */
    BRIGHTNESS: 'BRIGHTNESS',
    /** Check if current native timers are set as expected */
    TIMERS: 'TIMERS',
    /** Check if current proprietary timers are set as expected */
    PROPRIETARY_TIMERS: 'PROPRIETARY_TIMERS',
    /** Check if current resolution is set as expected */
    RESOLUTION: 'RESOLUTION',
    /** Check if current orientation is set as expected */
    ORIENTATION: 'ORIENTATION',
    /** Check if current RC is locked or not */
    REMOTE_CONTROL: 'REMOTE_CONTROL',
    /** Check if current core app version is correct */
    APPLICATION_VERSION: 'APPLICATION_VERSION',
    /** Check if current FW version match some string */
    FIRMWARE_VERSION: 'FIRMWARE_VERSION',
    /** Check if debug is enabled or not */
    DEBUG: 'DEBUG',
    /** Check if current scheduled power actions are correctly set */
    POWER_ACTIONS_SCHEDULE: 'POWER_ACTIONS_SCHEDULE',
    /** Check if temperature is in specified range in celsius */
    TEMPERATURE: 'TEMPERATURE',
    // Other info from different collections
    /** Check if specified package is installed */
    INSTALLED_PACKAGE: 'INSTALLED_PACKAGE',
    /** Check if number of screenshots was received in time */
    SCREENSHOT: 'SCREENSHOT',
    /** Check if feature tests has passed */
    FEATURE_TESTS: 'FEATURE_TESTS',
};
/**
 * Policy related condition types.
 * It contains violation of any of existing policy device settings type.
 * Copied from @signageos/common/devices library
 */
exports.PolicyConditionType = {
    POLICY_VIOLATION_VOLUME: 'POLICY_VIOLATION_VOLUME',
    POLICY_VIOLATION_BRIGHTNESS: 'POLICY_VIOLATION_BRIGHTNESS',
    POLICY_VIOLATION_TIMERS: 'POLICY_VIOLATION_TIMERS',
    POLICY_VIOLATION_PROPRIETARY_TIMERS: 'POLICY_VIOLATION_PROPRIETARY_TIMERS',
    POLICY_VIOLATION_RESOLUTION: 'POLICY_VIOLATION_RESOLUTION',
    POLICY_VIOLATION_ORIENTATION: 'POLICY_VIOLATION_ORIENTATION',
    POLICY_VIOLATION_REMOTE_CONTROL: 'POLICY_VIOLATION_REMOTE_CONTROL',
    POLICY_VIOLATION_APPLICATION_VERSION: 'POLICY_VIOLATION_APPLICATION_VERSION',
    POLICY_VIOLATION_FIRMWARE_VERSION: 'POLICY_VIOLATION_FIRMWARE_VERSION',
    POLICY_VIOLATION_DEBUG: 'POLICY_VIOLATION_DEBUG',
    POLICY_VIOLATION_DATETIME: 'POLICY_VIOLATION_DATETIME',
    POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE: 'POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE',
    POLICY_VIOLATION_TEMPERATURE: 'POLICY_VIOLATION_TEMPERATURE',
};
/** Applet related condition types */
exports.AppletConditionType = {
    /** Is used when to check custom user defined commands occurrences in time */
    APPLET_COMMAND: 'APPLET_COMMAND',
};
/** Union of all condition types */
exports.ConditionType = Object.assign(Object.assign(Object.assign({}, exports.DeviceConditionType), exports.PolicyConditionType), exports.AppletConditionType);
/** Kinds of conditions which defines operands and operators, and deduce which mathematical operation will be used in matching */
var ConditionKind;
(function (ConditionKind) {
    ConditionKind["BOOLEAN"] = "BOOLEAN";
    ConditionKind["OCCURRENCES_IN_TIME_RANGE_TO_PAST"] = "OCCURRENCES_IN_TIME_RANGE_TO_PAST";
    ConditionKind["STRING_OCCURRENCES_IN_TIME_RANGE_TO_PAST"] = "STRING_OCCURRENCES_IN_TIME_RANGE_TO_PAST";
    ConditionKind["TIME_RANGE_TO_PAST"] = "TIME_RANGE_TO_PAST";
    ConditionKind["PERCENTAGE_RANGE"] = "PERCENTAGE_RANGE";
    ConditionKind["NUMERIC_RANGE"] = "NUMERIC_RANGE";
    ConditionKind["MATCH_STRING"] = "MATCH_STRING";
    ConditionKind["MATCH_SEMVER"] = "MATCH_SEMVER";
    ConditionKind["STRING_LIST"] = "STRING_LIST";
    ConditionKind["POLICY_LIST"] = "POLICY_LIST";
    ConditionKind["WIFI_OR_ETHERNET"] = "WIFI_OR_ETHERNET";
    ConditionKind["INPUT_SOURCE"] = "INPUT_SOURCE";
    ConditionKind["TIMERS"] = "TIMERS";
    ConditionKind["PROPRIETARY_TIMERS"] = "PROPRIETARY_TIMERS";
    ConditionKind["RESOLUTION"] = "RESOLUTION";
    ConditionKind["ORIENTATION"] = "ORIENTATION";
    ConditionKind["SCHEDULED_POWER_ACTIONS"] = "SCHEDULED_POWER_ACTIONS";
})(ConditionKind || (exports.ConditionKind = ConditionKind = {}));
