import { z } from 'zod';
/**
 *  Defines the user's level in the application
 *  @preview  just after the registration, should be disallowed to do anything until is his accessLevel changed by the admin
 *  @open     basic level with limited rights
 *  @platform common level for paid customers
 *  @archived aka deleted, but the data remains. Archived user may not log in, but may be un-archived by admin
 *  @admin    aka Chuck Norris with unlimited rights for sOS stuff, but be aware that with great power comes the great responsibility
 */
export declare enum AccessLevel {
    Preview = "preview",
    Open = "open",
    Platform = "platform",
    Archived = "archived",
    Admin = "admin"
}
export declare const AccessLevelSchema: z.ZodNativeEnum<typeof AccessLevel>;
export declare enum AccountCreationReason {
    SignUp = "signup",
    Invite = "invite"
}
export declare const AccountCreationReasonSchema: z.ZodNativeEnum<typeof AccountCreationReason>;
export declare enum Role {
    Owner = "owner",
    Master = "master",
    User = "user",
    Guest = "guest"
}
export declare const RoleSchema: z.ZodNativeEnum<typeof Role>;
export declare const AccountLicensesSchema: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodNativeEnum<typeof import("../License/License").License>, "many">>;
export type AccountLicenses = z.infer<typeof AccountLicensesSchema>;
