"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStartedClient = createStartedClient;
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
function createStartedClient(client, connectedPromise, options) {
    if (options.timeoutMs) {
        const waitPromise = (0, wait_1.default)(options.timeoutMs);
        const connectedFinishedPromise = connectedPromise.then(() => waitPromise.cancel());
        const timeoutPromiseRejection = waitPromise.then(() => __awaiter(this, void 0, void 0, function* () {
            yield client.stop();
            throw new Error(`Establishing connection timed out after ${options.timeoutMs} ms`);
        }));
        connectedPromise = Promise.race([connectedFinishedPromise, timeoutPromiseRejection]);
    }
    return {
        stop: () => client.stop(),
        onceConnected: () => __awaiter(this, void 0, void 0, function* () { return connectedPromise; }),
    };
}
//# sourceMappingURL=client.js.map