import { MouseEventPayload, KeyEventPayload, ButtonEventPayload } from '../messages';
import { Client, ClientOptions, StartedClient } from '../client';
interface Options extends ClientOptions {
    serverUrl: string;
    /** The tokenId and token used to authenticate with x-auth query param concatenated with colon */
    auth: {
        tokenId: string;
        token: string;
    };
    /** Timeout of ping-pong in WS. Default to 30s */
    wsPingPongTimeoutMs?: number;
}
export interface Screenshot {
    screenshotUri: string;
    width: number;
    height: number;
}
export interface ScreenshotRenderer {
    render(screenshot: Screenshot): Promise<void>;
}
export declare class BrowserClient implements Client {
    /** The unique identifier of device (not DUID) */
    private readonly deviceUid;
    private readonly screenshotRenderer;
    private deviceConnected;
    private socket;
    constructor(
    /** The unique identifier of device (not DUID) */
    deviceUid: string, screenshotRenderer: ScreenshotRenderer);
    start(options: Options): Promise<StartedClient>;
    stop(): Promise<void>;
    isStarted(): boolean;
    isDeviceConnected(): boolean;
    sendMouseEvent(payload: MouseEventPayload): Promise<void>;
    sendKeyEvent(payload: KeyEventPayload): Promise<void>;
    sendButtonEvent(payload: ButtonEventPayload): Promise<void>;
    private connectWebSocket;
    private createWebSocketOptions;
    private bindSocketEvents;
    private sendEvent;
}
export {};
