const { getPipedInput, getGroupedChangeLog } = require('./helper');

const version = process.argv[2] || 'Unreleased';
const outputType = process.argv[3] || 'text';

(async function () {
	const changeLog = await getPipedInput();
	const groupedLog = getGroupedChangeLog(changeLog);
	let output;
	if (outputType === 'text') {
		const changedTypes = Object.keys(groupedLog[version] || {});
		const releaseNotes = changedTypes.reduce(
			(notes, changeType) => [...notes, `${changeType}:`, ...groupedLog[version][changeType].map((note) => `- ${note}`), ''],
			[],
		);
		output = releaseNotes.join('\n');
	} else if (outputType === 'groups') {
		output = typeof groupedLog[version] !== 'undefined' ? groupedLog[version] : {};
	}
	process.stdout.write(JSON.stringify(output));
})();

process.on('unhandledRejection', (error) => {
	throw error;
});
