"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createProgressiveWait = void 0;
const wait_1 = __importDefault(require("./wait"));
/**
 * Creates a progressive wait function that can be used to wait for a period of time,
 * and then progressively increase the wait time by a multiplier.
 *
 * @param initialTimeoutMs The initial timeout in milliseconds.
 * @param progressiveMultiplier The multiplier to use when increasing the timeout.
 * @param maxTimeoutMs The maximum timeout in milliseconds.
 * @example of usage:
 * const wait = createProgressiveWait(1000);
 * await wait(); // waits for 1000ms
 * await wait(); // waits for 2000ms
 * await wait(); // waits for 4000ms
 * await wait(); // waits for 8000ms
 * await wait(); // waits for 10000ms
 *
 * const wait = createProgressiveWait(1000, 3);
 * await wait(); // waits for 1000ms
 * await wait(); // waits for 3000ms
 * await wait(); // waits for 9000ms
 * await wait(); // waits for 10000ms
 */
const createProgressiveWait = (initialTimeoutMs, progressiveMultiplier = 2, maxTimeoutMs = initialTimeoutMs * 10) => {
    let currentTimeoutMs = initialTimeoutMs;
    return {
        wait() {
            return __awaiter(this, void 0, void 0, function* () {
                yield (0, wait_1.default)(currentTimeoutMs);
                currentTimeoutMs = this.getNextTimeoutMs();
            });
        },
        reset() {
            currentTimeoutMs = initialTimeoutMs;
        },
        getCurrentTimeoutMs() {
            return currentTimeoutMs;
        },
        getNextTimeoutMs() {
            return Math.min(currentTimeoutMs * progressiveMultiplier, maxTimeoutMs);
        },
    };
};
exports.createProgressiveWait = createProgressiveWait;
//# sourceMappingURL=progressiveWait.js.map