"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServer = void 0;
const http = __importStar(require("http"));
const debug_1 = __importDefault(require("debug"));
const wait_1 = __importDefault(require("../../../Timer/wait"));
const debug = (0, debug_1.default)('@signageos/lib:Service:HTTP:server:serverFactory');
/**
 * Create a HTTP server from an Express app running on a given port
 */
function createServer(app, port) {
    const server = http.createServer(app);
    server.on('error', (error) => console.error(error));
    return {
        server,
        listen() {
            return new Promise((resolve) => {
                server.listen(port, () => resolve());
            });
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                yield drainHttpServerConnections(server);
                yield new Promise((resolve) => {
                    server.close(() => resolve());
                });
            });
        },
    };
}
exports.createServer = createServer;
/**
 * Wait for the server to finish serving all requests
 */
function drainHttpServerConnections(httpServer) {
    return __awaiter(this, void 0, void 0, function* () {
        while (true) {
            const connectionsCount = yield getHttpServerConnections(httpServer);
            if (connectionsCount <= 0) {
                break;
            }
            debug(`Waiting for ${connectionsCount} connections to drain`);
            yield (0, wait_1.default)(100);
        }
    });
}
function getHttpServerConnections(httpServer) {
    return new Promise((resolve, reject) => httpServer.getConnections((error, count) => (error ? reject(error) : resolve(count))));
}
//# sourceMappingURL=serverFactory.js.map