"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.routeReadiness = void 0;
const http_status_1 = require("http-status");
/**
 * Runs readiness check and serves the result
 *
 * Responds with 200 if service is ready to serve requests.
 * Typically used by Kubernetes readiness probe.
 */
function routeReadiness({ router, isReady }) {
    router.get('/ready', (_req, res) => __awaiter(this, void 0, void 0, function* () {
        if (isReady) {
            const result = yield isReady();
            const ready = typeof result === 'boolean' ? result : result.ready;
            const response = typeof result === 'boolean' ? undefined : result.response;
            const status = ready ? http_status_1.OK : http_status_1.SERVICE_UNAVAILABLE;
            if (response) {
                res.status(status).send(response);
            }
            else {
                res.sendStatus(status);
            }
        }
        else {
            res.sendStatus(http_status_1.OK);
        }
    }));
}
exports.routeReadiness = routeReadiness;
//# sourceMappingURL=readniness.js.map