"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.routeAliveness = void 0;
const http_status_1 = require("http-status");
/**
 * Runs aliveness check and serves the result
 *
 * Responds with 200 if service is alive.
 * Typically used by Kubernetes aliveness probe.
 *
 * If no isAlive callback is provided, the route will always respond with 200 as long as the application didn't freeze.
 */
function routeAliveness({ router, isAlive }) {
    router.get('/alive', (_req, res) => __awaiter(this, void 0, void 0, function* () {
        if (isAlive) {
            const alive = yield isAlive();
            const status = alive ? http_status_1.OK : http_status_1.SERVICE_UNAVAILABLE;
            res.sendStatus(status);
        }
        else {
            res.sendStatus(http_status_1.OK);
        }
    }));
}
exports.routeAliveness = routeAliveness;
//# sourceMappingURL=aliveness.js.map