"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numerize = exports.normalizeString = exports.normalize = exports.isGreaterThan = exports.sortFunction = exports.getUpgradedVersion = void 0;
const pad_1 = require("../String/pad");
const semver = __importStar(require("semver"));
function getUpgradedVersion(version, level) {
    const versionParts = version.split('.');
    versionParts[2 - level] = (parseInt(versionParts[2 - level]) + 1).toString();
    for (let index = versionParts.length - 1; index > 2 - level; index--) {
        versionParts[index] = '0';
    }
    return versionParts.join('.');
}
exports.getUpgradedVersion = getUpgradedVersion;
function sortFunction(a, b) {
    return semver.compare(normalize(a), normalize(b));
}
exports.sortFunction = sortFunction;
function isGreaterThan(subject, compareWith) {
    return sortFunction(subject, compareWith) > 0;
}
exports.isGreaterThan = isGreaterThan;
function normalize(version) {
    const [mainVersion, ...restVersionParts] = version.toString().split('-');
    const versionParts = mainVersion.split('.');
    do {
        if (versionParts.length > 3) {
            versionParts.pop();
        }
        else if (versionParts.length < 3) {
            versionParts.unshift('0');
        }
    } while (versionParts.length !== 3);
    for (let index in versionParts) {
        versionParts[index] = isNaN(parseInt(versionParts[index])) ? '0' : parseInt(versionParts[index]).toString();
    }
    return [versionParts.join('.'), ...restVersionParts].join('-');
}
exports.normalize = normalize;
function normalizeString(version) {
    return (0, pad_1.padLeft)(numerize(version).toString(), 5 * 3, '0');
}
exports.normalizeString = normalizeString;
function numerize(version) {
    const versionParts = version.split('.');
    return versionParts.reduce((numerized, versionPart, index) => numerized + parseInt(versionPart) * Math.pow(1e5, versionParts.length - index - 1), 0);
}
exports.numerize = numerize;
//# sourceMappingURL=semVerHelper.js.map