"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.pushDevicePostponedAction = exports.popDevicePostponedActionIterator = exports.updateDeviceBoundActionTypes = void 0;
const _ = __importStar(require("lodash"));
const redisLock_1 = require("../../Redis/redisLock");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:Redis:DeviceActions:postponedDeviceActions');
/**
 * Update list of action types bound by a device and its particular socket name
 */
function updateDeviceBoundActionTypes(redisConnection, deviceUid, socketName, actionTypes) {
    return __awaiter(this, void 0, void 0, function* () {
        const releaseLock = yield acquireDeviceLock(redisConnection, deviceUid, socketName);
        try {
            const boundKey = getDeviceBoundActionTypesKey(deviceUid, socketName);
            debug('set device bound action types', deviceUid, socketName, actionTypes);
            const prevActionTypes = yield new Promise((resolve, reject) => {
                redisConnection.connection.smembers(boundKey, (error, result) => (error ? reject(error) : resolve(result)));
            });
            const newActionTypes = _.difference(actionTypes, prevActionTypes);
            if (newActionTypes.length > 0) {
                yield new Promise((resolve, reject) => {
                    redisConnection.connection.sadd(boundKey, newActionTypes, (error) => (error ? reject(error) : resolve()));
                });
            }
            const extraActionTypes = _.difference(prevActionTypes, actionTypes);
            if (extraActionTypes.length > 0) {
                yield new Promise((resolve, reject) => {
                    redisConnection.connection.srem(boundKey, extraActionTypes, (error) => (error ? reject(error) : resolve()));
                });
            }
        }
        finally {
            yield releaseLock();
        }
    });
}
exports.updateDeviceBoundActionTypes = updateDeviceBoundActionTypes;
function popDevicePostponedActionIterator(redisConnection, deviceUid, socketName) {
    return __asyncGenerator(this, arguments, function* popDevicePostponedActionIterator_1() {
        const releaseLock = yield __await(acquireDeviceLock(redisConnection, deviceUid, socketName));
        try {
            debug('peak next device postponed action', deviceUid, socketName);
            const postponedKey = getDevicePostponedActionsKey(deviceUid, socketName);
            // size = 0 when array doesn't exist
            const size = yield __await(new Promise((resolve) => {
                redisConnection.connection.llen(postponedKey, (error, length) => (error ? resolve(0) : resolve(length)));
            }));
            // prevent infinite loop of rotating messages by finite loop
            for (let i = 0; i < size; i++) {
                const action = yield __await(new Promise((resolve, reject) => {
                    // get the next action from the list but don't pop it until it's succesfully processed
                    redisConnection.connection.lindex(postponedKey, 0, (error, item) => error ? reject(error) : resolve(item ? JSON.parse(item) : null));
                }));
                debug('pop device postponed action', deviceUid, socketName, action);
                if (!action) {
                    // If other process emptied list
                    break;
                }
                yield yield __await(action);
                // now the action has been processed and we can pop it so it's removed from the list
                yield __await(new Promise((resolve, reject) => {
                    redisConnection.connection.lpop(postponedKey, (error) => (error ? reject(error) : resolve()));
                }));
            }
            const sizeAfterPop = yield __await(new Promise((resolve) => {
                redisConnection.connection.llen(postponedKey, (error, length) => (error ? resolve(0) : resolve(length)));
            }));
            // if list is empty after pop iterator done, remove key to minimize memory pressure
            if (sizeAfterPop === 0) {
                yield __await(new Promise((resolve, reject) => {
                    redisConnection.connection.del(postponedKey, (error) => (error ? reject(error) : resolve()));
                }));
            }
        }
        finally {
            yield __await(releaseLock());
        }
    });
}
exports.popDevicePostponedActionIterator = popDevicePostponedActionIterator;
function pushDevicePostponedAction(redisConnection, deviceUid, action) {
    return __awaiter(this, void 0, void 0, function* () {
        const socketNames = yield getSocketNamesWithBoundDeviceActionType(redisConnection, deviceUid, action.type);
        for (const socketName of socketNames) {
            yield pushDevicePostponedActionToSocket(redisConnection, deviceUid, socketName, action);
        }
    });
}
exports.pushDevicePostponedAction = pushDevicePostponedAction;
function getSocketNamesWithBoundDeviceActionType(redisConnection, deviceUid, actionType) {
    return __awaiter(this, void 0, void 0, function* () {
        debug('get socket names with bound device action type', deviceUid, actionType);
        const boundKeys = yield new Promise((resolve, reject) => {
            const boundKeyPattern = getDeviceBoundActionTypesKey(deviceUid, '*');
            redisConnection.connection.keys(boundKeyPattern, (error, keys) => (error ? reject(error) : resolve(keys)));
        });
        const boundKeyPrefix = getDeviceBoundActionTypesKey(deviceUid, '');
        const boundSocketNames = [];
        for (const boundKey of boundKeys) {
            // O(N) where N = number of socketNames ~ O(1)
            const exists = yield new Promise((resolve, reject) => {
                redisConnection.connection.sismember(boundKey, actionType, (error, isMember) => error ? reject(error) : resolve(isMember === 1));
            });
            if (exists) {
                const socketName = boundKey.substr(boundKeyPrefix.length);
                boundSocketNames.push(socketName);
            }
        }
        debug('got socket names with bound device action type', deviceUid, actionType, boundSocketNames);
        return boundSocketNames;
    });
}
function pushDevicePostponedActionToSocket(redisConnection, deviceUid, socketName, action) {
    return __awaiter(this, void 0, void 0, function* () {
        const releaseLock = yield acquireDeviceLock(redisConnection, deviceUid, socketName);
        try {
            const postponedKey = getDevicePostponedActionsKey(deviceUid, socketName);
            yield new Promise((resolve, reject) => {
                redisConnection.connection.rpush(postponedKey, JSON.stringify(action), (error) => (error ? reject(error) : resolve()));
            });
        }
        finally {
            yield releaseLock();
        }
    });
}
function acquireDeviceLock(redisConnection, deviceUid, socketName) {
    const REDIS_LOCK_OPTIONS = {
        acquireTimeout: 10e3,
        releaseTimeout: 10e3,
        retryDelay: 200,
        prolongInterval: 1e3,
        ttlExtraTimeout: 2e3,
    };
    const acquireLock = (0, redisLock_1.redisLock)(redisConnection.connection);
    const lockKey = getDeviceLockKey(deviceUid, socketName);
    return acquireLock(lockKey, REDIS_LOCK_OPTIONS);
}
function getDeviceLockKey(deviceUid, socketName) {
    return `deviceLock.${deviceUid}.${socketName}`;
}
function getDeviceBoundActionTypesKey(deviceUid, socketName) {
    // socketName has to be last because of redis prefix fetching
    return `deviceBoundActions.${deviceUid}.${socketName}`;
}
function getDevicePostponedActionsKey(deviceUid, socketName) {
    // socketName has to be last because of redis prefix fetching
    return `devicePostponedActions.${deviceUid}.${socketName}`;
}
//# sourceMappingURL=postponedDeviceActions.js.map