"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDsnIfProprietaryCluster = void 0;
const connection_string_parser_1 = require("connection-string-parser");
const random_1 = require("./ProprietaryCluster/SelectionStrategy/random");
const ordinary_1 = require("./ProprietaryCluster/SelectionStrategy/ordinary");
const dynamicPriority_1 = require("./ProprietaryCluster/SelectionStrategy/dynamicPriority");
const lowReadLatency_1 = require("./ProprietaryCluster/SelectionStrategy/lowReadLatency");
const connectionStringParser = new connection_string_parser_1.ConnectionStringParser({
    scheme: 'mongodb',
    hosts: [],
});
const selectionStrategies = {
    random: random_1.random,
    ordinary: ordinary_1.ordinary,
    dynamicPriority: dynamicPriority_1.dynamicPriority,
    lowReadLatency: lowReadLatency_1.lowReadLatency,
};
function updateDsnIfProprietaryCluster(originalDsn) {
    return __awaiter(this, void 0, void 0, function* () {
        const parsedDsn = connectionStringParser.parse(originalDsn);
        if (parsedDsn.options && parsedDsn.options.proprietaryReplicaSet) {
            const serverSelectionStrategy = parsedDsn.options.proprietaryServerSelectionStrategy;
            const selectionStrategy = selectionStrategies[serverSelectionStrategy];
            if (selectionStrategy) {
                return yield selectionStrategy(parsedDsn, originalDsn);
            }
            else {
                throw new Error(`Unknown proprietaryServerSelectionStrategy: ${serverSelectionStrategy}`);
            }
        }
        else {
            return originalDsn;
        }
    });
}
exports.updateDsnIfProprietaryCluster = updateDsnIfProprietaryCluster;
//# sourceMappingURL=proprietaryCluster.js.map