"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MongoDBConnection = void 0;
const mongoose = __importStar(require("mongoose"));
const debug_1 = __importDefault(require("debug"));
const proprietaryCluster_1 = require("./proprietaryCluster");
const genericGracefulExit_1 = require("../Events/genericGracefulExit");
mongoose.Promise = Promise;
const debug = (0, debug_1.default)('@signageos/lib:MongoDB:mongoDBConnectionFactory');
const defaultOptions = {
    autoIndex: false,
    connectTimeoutMS: 10 * 60 * 1e3,
    socketTimeoutMS: 3 * 60 * 60 * 1e3,
    monitorCommands: true,
};
class MongoDBConnection {
    constructor(mongoDbDsn, options = {}, onExit) {
        this.mongoDbDsn = mongoDbDsn;
        this.connection = null;
        this.metrics = null;
        this.options = Object.assign(Object.assign({}, defaultOptions), options);
        const reconnectTimeout = 30e3;
        this.gracefulExit = new genericGracefulExit_1.GenericGracefulExit('mongo', reconnectTimeout, onExit);
    }
    connect() {
        return __awaiter(this, void 0, void 0, function* () {
            debug('connect');
            const updatedMongDbDsn = yield (0, proprietaryCluster_1.updateDsnIfProprietaryCluster)(this.mongoDbDsn);
            const connection = mongoose.createConnection(updatedMongDbDsn, this.options);
            this.applyGracefulExit(connection);
            if (this.metrics) {
                this.monitorConnection(connection, this.metrics.exporter, this.metrics.connectionName);
            }
            yield connection.asPromise();
            debug('connected');
            this.connection = connection;
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.connection) {
                yield this.connection.close();
            }
        });
    }
    monitor(exporter, connectionName) {
        if (this.connection) {
            debug(`monitor connection ${connectionName} now`);
            this.monitorConnection(this.connection, exporter, connectionName);
        }
        else {
            debug(`monitor connection ${connectionName}, once it connects`);
            // if connection is not yet established, store the exporter and name for later use
            this.metrics = {
                exporter,
                connectionName,
            };
        }
    }
    applyGracefulExit(connection) {
        connection.on('disconnected', () => __awaiter(this, void 0, void 0, function* () {
            yield this.gracefulExit.waitToConnectOrDie();
        }));
        connection.on('error', (_err) => __awaiter(this, void 0, void 0, function* () {
            yield this.gracefulExit.waitToConnectOrDie();
        }));
        connection.on('connected', () => __awaiter(this, void 0, void 0, function* () {
            this.gracefulExit.connected();
        }));
        connection.on('close', () => __awaiter(this, void 0, void 0, function* () {
            this.gracefulExit.closed();
        }));
    }
    /**
     * @see https://www.mongodb.com/docs/drivers/node/current/fundamentals/monitoring/command-monitoring/#command-monitoring
     */
    monitorConnection(connection, exporter, connectionName) {
        debug(`monitor connection ${connectionName}`);
        const mongoClient = connection.getClient();
        exporter.monitorMongoClient(mongoClient, connectionName);
        const eventNames = ['commandStarted', 'commandSucceeded', 'commandFailed'];
        for (const eventName of eventNames) {
            mongoClient.addListener(eventName, (event) => {
                debug(eventName, 
                // https://github.com/GoogleChromeLabs/jsbi/issues/30
                JSON.stringify(event, (_key, value) => (typeof value === 'bigint' ? value.toString() : value)));
            });
        }
    }
}
exports.MongoDBConnection = MongoDBConnection;
//# sourceMappingURL=MongoDBConnection.js.map