"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WinstonLogger = exports.useRavenLogging = void 0;
// for backwards compatibility, because a bunch of repos import from here
var raven_1 = require("./raven");
Object.defineProperty(exports, "useRavenLogging", { enumerable: true, get: function () { return raven_1.useRavenLogging; } });
class WinstonLogger {
    constructor(logger, namespace) {
        this.logger = logger;
        this.namespace = namespace;
        // do nothing
    }
    error(message, meta) {
        this.log('error', message, meta);
        return this;
    }
    warn(message, meta) {
        this.log('warn', message, meta);
        return this;
    }
    info(message, meta) {
        this.log('info', message, meta);
        return this;
    }
    debug(message, meta) {
        this.log('debug', message, meta);
        return this;
    }
    createNamespace(namespace) {
        const prefix = this.namespace ? `${this.namespace}:` : '';
        return new WinstonLogger(this.logger, prefix + namespace);
    }
    log(level, message, meta) {
        this.logger.log(level, message, Object.assign({ namespace: this.namespace }, meta));
    }
}
exports.WinstonLogger = WinstonLogger;
//# sourceMappingURL=logger.js.map