"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const wait_1 = __importDefault(require("../Timer/wait"));
const time = __importStar(require("../DateTime/dateTimeFactory"));
const generator_1 = require("../Hash/generator");
function default_1(connections, checkStatus, label, serviceUid) {
    return (timeout) => __awaiter(this, void 0, void 0, function* () {
        const servicesResponses = {};
        yield Promise.all(connections.map((conn, index) => __awaiter(this, void 0, void 0, function* () {
            const requestedAt = time.now();
            try {
                const responseData = yield Promise.race([
                    checkStatus(conn, `${serviceUid}_${index}_${(0, generator_1.generateUniqueHash)(6)}`),
                    (0, wait_1.default)(timeout).then(() => Promise.reject(new Error(`Status check timed-out`))),
                ]);
                const respondedAt = time.now();
                servicesResponses[label + index] = {
                    response: Object.assign({ requestedAt: requestedAt.valueOf(), respondedAt: respondedAt.valueOf(), responseTime: respondedAt.diff(requestedAt).valueOf() }, responseData),
                };
            }
            catch (error) {
                const failedAt = time.now();
                servicesResponses[label + index] = {
                    error: {
                        message: error.message,
                        requestedAt: requestedAt.valueOf(),
                        failedAt: failedAt.valueOf(),
                        errorTime: failedAt.diff(requestedAt).valueOf(),
                    },
                };
            }
        })));
        return servicesResponses;
    });
}
exports.default = default_1;
//# sourceMappingURL=status.js.map