"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendStatusResponse = void 0;
const time = __importStar(require("../DateTime/dateTimeFactory"));
const os = __importStar(require("os"));
const HttpStatus = __importStar(require("http-status"));
function sendStatusResponse(req, res, name, uid, timeout, statusRequestedAt, serviceGroupResponses, additionalDataCallback = () => undefined) {
    const serviceNames = Object.keys(serviceGroupResponses);
    const failedServices = serviceNames.filter((serviceName) => 'error' in serviceGroupResponses[serviceName]);
    const succeededServices = serviceNames.filter((serviceName) => 'response' in serviceGroupResponses[serviceName]);
    const success = failedServices.length === 0;
    const statusResponse = {
        name,
        status: success ? 'OK' : 'FAILED',
        process: {
            uid,
            pid: process.pid,
            version: process.version,
            uptime: process.uptime(),
            cpuUsage: process.cpuUsage(),
            memoryUsage: process.memoryUsage(),
        },
        hostname: os.hostname(),
        failedServices,
        succeededServices,
        timeout,
        requestedAt: statusRequestedAt.valueOf(),
        respondedAt: time.now().valueOf(),
    };
    const response = Object.assign(Object.assign(Object.assign({}, statusResponse), additionalDataCallback(req)), serviceGroupResponses);
    res.status(success ? HttpStatus.OK : HttpStatus.SERVICE_UNAVAILABLE).send(response);
}
exports.sendStatusResponse = sendStatusResponse;
//# sourceMappingURL=sendStatusResponse.js.map