"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.REDIS_LABEL = void 0;
exports.REDIS_LABEL = 'redis';
function default_1(redisConnection, uid) {
    return __awaiter(this, void 0, void 0, function* () {
        const HEALTH_CHECK_KEY = `___${uid}_check_connection_status`;
        const HEALTH_CHECK_VALUE = `${uid}_this_will_be_returned_if_connection_is_working`;
        yield new Promise((resolve, reject) => redisConnection.connection.set(HEALTH_CHECK_KEY, HEALTH_CHECK_VALUE, 'EX', 30, (error) => {
            if (error) {
                reject(error);
            }
            else {
                resolve();
            }
        }));
        const result = yield new Promise((resolve, reject) => redisConnection.connection.get(HEALTH_CHECK_KEY, (error, value) => {
            if (error) {
                reject(error);
            }
            else {
                resolve(value);
            }
        }));
        yield new Promise((resolve, reject) => redisConnection.connection.del(HEALTH_CHECK_KEY, (error) => {
            if (error) {
                reject(error);
            }
            else {
                resolve();
            }
        }));
        if (result !== HEALTH_CHECK_VALUE) {
            throw new Error(`Value returned by redis DB is not the same that was saved there. ${HEALTH_CHECK_KEY}, ${HEALTH_CHECK_VALUE}, ${result}`);
        }
        return {};
    });
}
exports.default = default_1;
//# sourceMappingURL=redisStatusCheck.js.map