"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncDelegator = (this && this.__asyncDelegator) || function (o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
};
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.walk = exports.transpileToES5 = exports.transpileFiles = exports.resolveConfig = exports.printBanner = exports.handleWatchMode = exports.handleBuildMode = exports.buffer = exports.addLiveReloading = void 0;
const core_1 = require("@swc/core");
const debug_1 = __importDefault(require("debug"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const IBundler_1 = require("../IBundler");
const debug = (0, debug_1.default)('@signageos/lib:Bundler');
function addLiveReloading(source, dest, origin = '') {
    return __awaiter(this, void 0, void 0, function* () {
        const indexFile = yield fs.promises.readFile(source);
        yield fs.promises.writeFile(dest, indexFile
            .toString('utf-8')
            .replace('</body>', `<script>new EventSource("${origin}/esbuild").addEventListener('change', () => location.reload())</script></body>`));
    });
}
exports.addLiveReloading = addLiveReloading;
// Buffers async iteratable to array
function buffer(iterable) {
    var _a, iterable_1, iterable_1_1;
    var _b, e_1, _c, _d;
    return __awaiter(this, void 0, void 0, function* () {
        const buf = [];
        try {
            for (_a = true, iterable_1 = __asyncValues(iterable); iterable_1_1 = yield iterable_1.next(), _b = iterable_1_1.done, !_b;) {
                _d = iterable_1_1.value;
                _a = false;
                try {
                    const x = _d;
                    buf.push(x);
                }
                finally {
                    _a = true;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (!_a && !_b && (_c = iterable_1.return)) yield _c.call(iterable_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return buf;
    });
}
exports.buffer = buffer;
function handleBuildMode(ctx) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log('ESBuild is rebuilding...');
        const { metafile } = yield ctx.rebuild();
        if (metafile) {
            fs.promises.writeFile('./meta.json', JSON.stringify(metafile));
        }
        yield ctx.dispose();
    });
}
exports.handleBuildMode = handleBuildMode;
function handleWatchMode(ctx, mode, serveOptions) {
    return __awaiter(this, void 0, void 0, function* () {
        console.info('ESBuild is watching...');
        yield ctx.rebuild();
        yield ctx.watch();
        if (mode === 'serve') {
            const { port } = yield ctx.serve(serveOptions);
            console.info(`Serving files on http://localhost:${port}`);
        }
    });
}
exports.handleWatchMode = handleWatchMode;
function printBanner(config) {
    // Convert the config object into an array of key-value pairs
    const entries = Object.entries(config);
    // Calculate the maximum key length
    const maxKeyLength = Math.max(...entries.map(([key]) => key.length));
    // Generate the lines of the banner
    const lines = entries.map(([key, value]) => {
        const paddedKey = key.padEnd(maxKeyLength + 2, ' ');
        return `${paddedKey}: ${String(value)}`;
    });
    // Print the banner
    console.log(`
${IBundler_1.BUNDLER_NAME}
${lines.join('\n')}
`);
}
exports.printBanner = printBanner;
function resolveConfig({ outdir, parameters, argv }) {
    const mode = argv.includes('--serve') ? 'serve' : argv.includes('--watch') ? 'watch' : 'build';
    const config = {
        environment: parameters.environment,
        NODE_ENV: parameters.NODE_ENV,
        outdir,
        mode,
        typeCheck: !argv.includes('--skipTypeCheck') && mode === 'build',
    };
    return config;
}
exports.resolveConfig = resolveConfig;
function transpileFiles(files, options) {
    var _a, files_1, files_1_1;
    var _b, e_2, _c, _d;
    return __awaiter(this, void 0, void 0, function* () {
        const promises = [];
        try {
            for (_a = true, files_1 = __asyncValues(files); files_1_1 = yield files_1.next(), _b = files_1_1.done, !_b;) {
                _d = files_1_1.value;
                _a = false;
                try {
                    const file = _d;
                    promises.push((() => __awaiter(this, void 0, void 0, function* () {
                        if (!file.endsWith('.js')) {
                            return;
                        }
                        debug(`Transpiling the file ${file} to es5`);
                        const source = yield fs.promises.readFile(file);
                        const output = yield (0, core_1.transform)(source.toString('utf-8'), options);
                        yield fs.promises.writeFile(file, output.code);
                    }))());
                }
                finally {
                    _a = true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (!_a && !_b && (_c = files_1.return)) yield _c.call(files_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        yield Promise.all(promises);
    });
}
exports.transpileFiles = transpileFiles;
// Transpiles all js files in `outdir` to ES5 with SWC
function transpileToES5({ outdir, options = {} }) {
    return __awaiter(this, void 0, void 0, function* () {
        // files in the `outdir` folder need to be transpiled by SWC to the es5 target
        // https://github.com/evanw/esbuild/issues/297
        const extendedOptions = Object.assign({ isModule: false }, options);
        yield transpileFiles(walk(outdir), extendedOptions);
    });
}
exports.transpileToES5 = transpileToES5;
// Walks a directory and yields every file
function walk(root, p = '.') {
    return __asyncGenerator(this, arguments, function* walk_1() {
        if ((yield __await(fs.promises.stat(root))).isFile()) {
            yield yield __await(root);
            return yield __await(void 0);
        }
        const dir = yield __await(fs.promises.readdir(path.join(root, p), { withFileTypes: true }));
        for (const e of dir) {
            if (e.isDirectory()) {
                yield __await(yield* __asyncDelegator(__asyncValues(walk(root, path.join(p, e.name)))));
            }
            if (e.isFile()) {
                yield yield __await(path.join(root, p, e.name));
            }
        }
    });
}
exports.walk = walk;
//# sourceMappingURL=bundlerUtils.js.map