"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundler = exports.TEMP_FOLDER_NAME = exports.ES_6_FOLDER_NAME = exports.BUNDLER_DIRECTORY_PATH = exports.BUNDLED_FILE_NAME = void 0;
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const child_process_1 = require("child_process");
const glob_1 = require("glob");
const bundlerUtils_1 = require("./utils/bundlerUtils");
exports.BUNDLED_FILE_NAME = 'bundle.js';
exports.BUNDLER_DIRECTORY_PATH = './node_modules/@signageos/lib/dist/ESBuild/';
exports.ES_6_FOLDER_NAME = 'es6';
exports.TEMP_FOLDER_NAME = 'temp';
class Bundler {
    constructor({ outdir, parameters, serveOptions, argv }) {
        this.DEFAULT_CHROME_VERSION = 32;
        this.serveOptions = {
            port: 3000,
        };
        // ts generates better types w/o typedef
        // eslint-disable-next-line @typescript-eslint/typedef
        this.esbuildOptions = {
            outdir: '',
            bundle: true,
            format: 'iife',
            logLevel: 'info',
            sourcemap: true,
            target: 'es6',
            treeShaking: true,
        };
        const config = (0, bundlerUtils_1.resolveConfig)({ outdir, parameters, argv });
        (0, bundlerUtils_1.printBanner)(config);
        this.config = config;
        this.serveOptions = Object.assign(Object.assign({}, this.serveOptions), serveOptions);
        this.esbuildOptions = Object.assign(Object.assign({}, this.esbuildOptions), { outdir });
    }
    static copyAssetsToEs6Folder(expression = 'src/**/*.{sass,svg}') {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                // Get all files matching the expression in the 'src' directory and its subdirectories
                const files = yield (0, glob_1.glob)(expression);
                // Create an array of promises for copying each file
                const copyPromises = files.map((file) => {
                    // Calculate the destination path by replacing 'src' with 'es6'
                    const destinationPath = exports.ES_6_FOLDER_NAME + '/' + file.substr('src/'.length);
                    // Return a promise for copying the file
                    return fs.copy(file, destinationPath);
                });
                // Wait for all copy operations to finish
                yield Promise.all(copyPromises);
            }
            catch (error) {
                console.error(`Failed to copy assets to ES6 folder: ${error}`);
                throw error;
            }
        });
    }
    // Converts the input to a JSON string.
    static enc(x) {
        try {
            return x === undefined ? 'undefined' : JSON.stringify(x);
        }
        catch (error) {
            console.error(`Failed to stringify JSON: ${error}`);
            throw error;
        }
    }
    static prepareEs6Folder() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield fs.mkdir('./' + exports.ES_6_FOLDER_NAME, { recursive: true });
            }
            catch (error) {
                console.error(`Failed to prepare ES6 folder: ${error}`);
                throw error;
            }
        });
    }
    // Bundles source files to `outdir` and watch & serve them in watch mode
    build(ctx, watchInsteadOfServe = false) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let mode = this.config.mode;
                mode = mode === 'serve' && watchInsteadOfServe ? 'watch' : mode;
                if (mode === 'watch' || mode === 'serve') {
                    const serveOptions = {
                        servedir: this.config.outdir,
                        port: this.serveOptions.port,
                    };
                    yield (0, bundlerUtils_1.handleWatchMode)(ctx, mode, serveOptions);
                }
                else {
                    yield (0, bundlerUtils_1.handleBuildMode)(ctx);
                }
            }
            catch (error) {
                console.error(`Failed to build: ${error}`);
                throw error;
            }
        });
    }
    compileTypescript(tscArgs = ['-p', 'tsconfig.es6.json'], force) {
        return __awaiter(this, void 0, void 0, function* () {
            const shouldTypecheck = force || this.config.typeCheck;
            if (!shouldTypecheck) {
                console.log('Skipping typescript compilation because of the --serve or --skipTypeCheck flag.');
                return;
            }
            try {
                const tsc = (0, child_process_1.spawn)('tsc', tscArgs, { stdio: 'inherit' });
                yield new Promise((resolve, reject) => {
                    tsc.on('close', (code) => __awaiter(this, void 0, void 0, function* () {
                        if (code !== 0) {
                            reject(new Error(`tsc process exited with code ${code}`));
                        }
                        else {
                            resolve();
                        }
                    }));
                    tsc.on('error', (error) => {
                        reject(new Error(`Failed to start tsc process: ${error.message}`));
                    });
                });
            }
            catch (error) {
                console.error(`Failed to compile TypeScript: ${error}`);
                throw error;
            }
        });
    }
    // Transpiles all js files in `outdir` to ES5 with SWC
    transpileToES5(options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield (0, bundlerUtils_1.transpileToES5)({ outdir: this.config.outdir, options: options });
            }
            catch (error) {
                console.error(`Error during transpilation to ES5: ${error}`);
                throw error;
            }
        });
    }
    // Writes index.html file to `outdir` folder and enables hot reload in the serve mode
    writeIndexFile(source, destInOutdir = 'index.html', origin = '') {
        return __awaiter(this, void 0, void 0, function* () {
            const dest = path.resolve(this.config.outdir, destInOutdir);
            try {
                console.info(`Writing index file "${source}" to ${dest}`);
                yield fs.promises.mkdir(this.config.outdir, { recursive: true });
                if (['watch', 'serve'].includes(this.config.mode)) {
                    yield (0, bundlerUtils_1.addLiveReloading)(source, dest, origin);
                }
                else {
                    yield fs.promises.copyFile(source, dest);
                }
            }
            catch (error) {
                console.error(`Failed to write index file: ${error}`);
                throw error;
            }
        });
    }
    cleanOutDir(preservedFiles = [exports.BUNDLED_FILE_NAME, exports.BUNDLED_FILE_NAME + '.map']) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const files = yield fs.readdir(this.config.outdir);
                for (const file of files) {
                    if (!preservedFiles.includes(file)) {
                        yield fs.rm(path.join(this.config.outdir, file), { recursive: true, force: true });
                    }
                }
            }
            catch (error) {
                console.error(`Failed to clean dist folder: ${error}`);
                throw error;
            }
        });
    }
}
exports.Bundler = Bundler;
//# sourceMappingURL=Bundler.js.map