"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.observeInterval = exports.wait = void 0;
function wait(window, timeout) {
    return new Promise((resolve) => window.setTimeout(resolve, timeout));
}
exports.wait = wait;
function observeInterval(window, interval) {
    return new Observable((observer) => {
        const runningInterval = window.setInterval(() => observer.next(undefined), interval);
        return () => window.clearInterval(runningInterval);
    });
}
exports.observeInterval = observeInterval;
//# sourceMappingURL=timer.js.map