"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsS3 = void 0;
const fs_1 = require("fs");
const client_s3_1 = require("@aws-sdk/client-s3");
const fs_extra_1 = require("fs-extra");
const debugDecorator_1 = require("../Debug/debugDecorator");
const config_1 = require("./config");
const DEBUG_NAMESPACE = '@signageos/lib:AWS:S3';
/**
 * Wrapper for AWS S3 client
 *
 * All commonly used operations with S3 will be implemented here to provide a consistent interface across the codebase.
 */
class AwsS3 {
    /**
     * @param config.forcePathStyle - Whether to use path style URLs for S3 requests.
     * Defaults to the value of the `AWS_S3_FORCE_PATH_STYLE_URLS` environment variable or false if not set.
     */
    constructor(config = {}) {
        config = (0, config_1.getUpdatedS3ClientConfigWithCustomEnvVars)(config);
        this.client = new client_s3_1.S3Client(config);
    }
    uploadFile({ filePath, bucket, remotePath, contentType }) {
        return __awaiter(this, void 0, void 0, function* () {
            const fileStream = (0, fs_1.createReadStream)(filePath);
            const command = new client_s3_1.PutObjectCommand({
                Bucket: bucket,
                Key: remotePath,
                Body: fileStream,
                ContentType: contentType,
            });
            yield this.client.send(command);
        });
    }
    uploadContent({ content, bucket, remotePath, contentType }) {
        return __awaiter(this, void 0, void 0, function* () {
            const command = new client_s3_1.PutObjectCommand({
                Bucket: bucket,
                Key: remotePath,
                Body: content,
                ContentType: contentType,
            });
            yield this.client.send(command);
        });
    }
    downloadFile({ bucket, remotePath, filePath }) {
        return __awaiter(this, void 0, void 0, function* () {
            const command = new client_s3_1.GetObjectCommand({
                Bucket: bucket,
                Key: remotePath,
            });
            const { Body: body } = yield this.client.send(command);
            if (body === undefined) {
                throw new Error('Body is undefined');
            }
            const response = body;
            const nodejsWriteStream = (0, fs_extra_1.createWriteStream)(filePath);
            response.pipe(nodejsWriteStream);
            yield new Promise((resolve, reject) => {
                nodejsWriteStream.on('finish', resolve);
                nodejsWriteStream.on('error', reject);
            });
        });
    }
    listFiles({ bucket, remotePath }) {
        return __awaiter(this, void 0, void 0, function* () {
            const command = new client_s3_1.ListObjectsV2Command({
                Bucket: bucket,
                Prefix: remotePath.endsWith('/') ? remotePath : remotePath + '/',
            });
            const { Contents: contents } = yield this.client.send(command);
            if (contents === undefined) {
                return [];
            }
            return contents.map((content) => content.Key).filter((key) => key !== undefined);
        });
    }
}
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "uploadFile", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "uploadContent", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "downloadFile", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AwsS3.prototype, "listFiles", null);
exports.AwsS3 = AwsS3;
//# sourceMappingURL=S3.js.map