"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindMessage = exports.bindMessageRetryable = void 0;
const wait_1 = __importDefault(require("../Timer/wait"));
const jsonHelper_1 = require("../JSON/jsonHelper");
const queueConfigurator_1 = require("./queueConfigurator");
function bindMessageRetryable(amqpConnection, queueName, onMessage, options = {}, delayBeforeRetry = 1000) {
    return __awaiter(this, void 0, void 0, function* () {
        while (true) {
            yield new Promise((resolve) => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield bindMessage(amqpConnection, queueName, onMessage, options, () => resolve());
                }
                catch (error) {
                    resolve();
                }
            }));
            yield (0, wait_1.default)(delayBeforeRetry);
        }
    });
}
exports.bindMessageRetryable = bindMessageRetryable;
function bindMessage(amqpConnection, queueName, onMessage, options = {}, onEnded) {
    return __awaiter(this, void 0, void 0, function* () {
        const connection = yield amqpConnection.pool.acquire(options.priority);
        const channel = yield connection.createConfirmChannel();
        channel.once('error', (error) => {
            if (onEnded) {
                onEnded();
                onEnded = undefined;
            }
            throw error;
        });
        channel.once('close', () => {
            if (onEnded) {
                onEnded();
                onEnded = undefined;
            }
        });
        yield (0, queueConfigurator_1.assertRejectableQueue)(channel, queueName, options.maxPriority);
        yield channel.consume(queueName, (amqpMessage) => __awaiter(this, void 0, void 0, function* () {
            try {
                const message = JSON.parse(amqpMessage.content.toString(), jsonHelper_1.deserializeJSON);
                yield onMessage(message);
                channel.ack(amqpMessage);
            }
            catch (error) {
                channel.nack(amqpMessage);
                throw error;
            }
        }));
    });
}
exports.bindMessage = bindMessage;
//# sourceMappingURL=bindMessage.js.map