"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindDeleteByFilter = exports.deleteByFilter = exports.saveFileBuffer = exports.saveFile = void 0;
const fs = __importStar(require("fs"));
const jsonHelper_1 = require("../../JSON/jsonHelper");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:AMQP:Static:filesQueue');
const UPLOAD_QUEUE_NAME = 'static.files.upload';
const DELETE_MORE_QUEUE_NAME = 'static.files.delete_more';
function saveFile(amqpConnection, fileName, filePath, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const fileBuffer = yield new Promise((resolve, reject) => fs.readFile(filePath, (error, data) => (error ? reject(error) : resolve(data))));
        yield saveFileBuffer(amqpConnection, fileName, fileBuffer, options);
    });
}
exports.saveFile = saveFile;
function saveFileBuffer(amqpConnection, fileName, fileBuffer, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const connection = yield amqpConnection.pool.acquire();
        try {
            const channel = yield connection.createChannel();
            channel.sendToQueue(UPLOAD_QUEUE_NAME, fileBuffer, { headers: Object.assign({ fileName }, options) });
            yield channel.close();
        }
        finally {
            yield amqpConnection.pool.release(connection);
        }
    });
}
exports.saveFileBuffer = saveFileBuffer;
function deleteByFilter(amqpConnection, filter) {
    return __awaiter(this, void 0, void 0, function* () {
        const connection = yield amqpConnection.pool.acquire();
        try {
            const channel = yield connection.createChannel();
            channel.sendToQueue(DELETE_MORE_QUEUE_NAME, new Buffer(JSON.stringify(filter)));
            yield channel.close();
        }
        finally {
            yield amqpConnection.pool.release(connection);
        }
    });
}
exports.deleteByFilter = deleteByFilter;
function bindDeleteByFilter(amqpConnection, onDelete) {
    return __awaiter(this, void 0, void 0, function* () {
        const queueName = DELETE_MORE_QUEUE_NAME;
        const connection = yield amqpConnection.pool.acquire();
        const channel = yield connection.createChannel();
        try {
            const { queue, messageCount, consumerCount } = yield channel.assertQueue(queueName, {
                maxPriority: 10,
                durable: true,
            });
            debug('asserted queue', { queue, messageCount, consumerCount });
            const { consumerTag } = yield channel.consume(queueName, (message) => {
                const filter = JSON.parse(message.content.toString(), jsonHelper_1.deserializeJSON);
                onDelete(filter, () => channel.ack(message), () => channel.nack(message));
            });
            return () => __awaiter(this, void 0, void 0, function* () {
                yield channel.cancel(consumerTag);
                yield channel.close();
                yield amqpConnection.pool.release(connection);
            });
        }
        catch (error) {
            yield channel.close();
            yield amqpConnection.pool.release(connection);
            throw error;
        }
    });
}
exports.bindDeleteByFilter = bindDeleteByFilter;
//# sourceMappingURL=filesQueue.js.map