"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindAll = exports.enqueue = void 0;
const QUEUE_NAME = 'device_logs';
const OPTIONS = {
    persistent: false,
    confirmable: false,
    prefetchCount: 300,
};
function enqueue(amqpConnection, deviceLog) {
    return __awaiter(this, void 0, void 0, function* () {
        const createChannel = () => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(QUEUE_NAME, 'fanout');
            return channel;
        });
        yield amqpConnection.queuePublisher.enqueue(createChannel, deviceLog, undefined, QUEUE_NAME, QUEUE_NAME, { persistent: false });
    });
}
exports.enqueue = enqueue;
function bindAll(amqpConnection, onDeviceLog) {
    return __awaiter(this, void 0, void 0, function* () {
        const createChannel = () => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(QUEUE_NAME, OPTIONS);
            yield channel.assertExchange(QUEUE_NAME, 'fanout');
            return channel;
        });
        return yield amqpConnection.queueSubscriber.subscribeRepeatable(createChannel, QUEUE_NAME, [{ exchangeName: QUEUE_NAME, routingKey: QUEUE_NAME, persistent: true }], onDeviceLog, {
            queueType: 'classic',
            autoDelete: false,
            durable: true,
        });
    });
}
exports.bindAll = bindAll;
//# sourceMappingURL=logDeviceQueue.js.map