import { IAMQPConnection } from '../amqpConnectionFactory';
import INackOptions from '../INackOptions';
import IEvent, { IEventPayload } from './IEvent';
import { QueueType } from '../IConsumeOptions';
import IMessageOptions from '../IMessageOptions';
import IQueueOptions from '../IQueueOptions';
export interface IBindOptions {
    persistent?: boolean;
    exclusive?: boolean;
    prefetchCount?: number;
    singleActiveConsumer?: boolean;
    deadLetterIfRedeliveredAndErred?: boolean;
    /** Whether first simple consumption error should not be thrown (just nacked for next redeliver) */
    suppressFirstError?: boolean;
    /** When message was already nacked (requeue: true), then next consumption will be delayed by number of milliseconds */
    redeliverDelayMs?: number;
    /** @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead */
    notification?: boolean;
    /**
     * Whether the queue type is created as quorum or classic.
     * It cannot be changed later. Only strictly persistent queue with "mirroring" requirements should be quorum.
     * Default value is quorum.
     */
    queueType?: QueueType;
}
export interface IRejectedRedeliverOptions {
    /**
     * Configure how long it will wait in the rejected queue until it's tried to be redelivered to the original queue.
     * Specify in milliseconds.
     */
    redeliverDelayMs: number;
}
export interface IEventMessage<TPayload extends IEventPayload> {
    event: IEvent<TPayload>;
    domain: string;
    ack(): Promise<void>;
    nack(nackOptions?: INackOptions): Promise<void>;
}
export interface IEventDetachedMessage<TPayload extends IEventPayload> {
    event: IEvent<TPayload>;
    ack(): Promise<void>;
    nack(nackOptions?: INackOptions): Promise<void>;
}
export declare function enqueue(amqpConnection: IAMQPConnection, event: IEvent<IEventPayload>, messageOptions?: IMessageOptions): Promise<void>;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
export declare function enqueueNotification(amqpConnection: IAMQPConnection, event: IEvent<IEventPayload>): Promise<void>;
export declare function enqueueToConsumer(amqpConnection: IAMQPConnection, event: IEvent<IEventPayload>, consumerType: string, eventTypeOrDomainName?: string, messageOptions?: IMessageOptions): Promise<void>;
export declare function fetchNext<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, bindOptions?: IBindOptions, queueOptions?: IQueueOptions, domainName?: string): Promise<IEvent<TPayload> | null>;
export declare function fetchAll<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, options?: IBindOptions): Promise<IEvent<TPayload>[]>;
/**
 * @deprecated Use bindMany instead.
 * This methods only calls bindOne function for every eventType.
 * If you'd like to compose consumption of more event types into one queue, see the bindMany instead.
 */
export declare function bindMore<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventTypes: string[], consumerType: string, onEvent: (event: IEvent<TPayload>) => Promise<void>, options?: IBindOptions): Promise<void>;
/**
 * Bind more event types into one single queue.
 * This queue name contains specified domainName and is prefixed by consumerType.
 */
export declare function bindMany<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventTypes: string[], domainName: string, consumerType: string, onEvent: (event: IEvent<TPayload>) => Promise<void>, options?: IBindOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
/**
 * Bind all events which were rejected with enqueue=false by bindMany function (the domain type only).
 */
export declare function bindRejectedMany(amqpConnection: IAMQPConnection, domainName: string, consumerType: string, onEvent: (event: IEvent<IEventPayload>) => Promise<void>, redeliverOptions: IRejectedRedeliverOptions, options?: IBindOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
/**
 * Fetch on event which were rejected with enqueue=false by bindMany function (the domain type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
export declare function fetchOneRejected(amqpConnection: IAMQPConnection, domainName: string, consumerType: string): Promise<IEventMessage<IEventPayload> | null>;
/**
 * Bind one event which were rejected with enqueue=false by bindOne function (the detached type only).
 */
export declare function bindRejectedDetached<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, onEvent: (event: IEvent<TPayload>) => Promise<void>, redeliverOptions: IRejectedRedeliverOptions, bindOptions?: IBindOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
/**
 * Fetch on event which were rejected with enqueue=false by bindOne function (the detached type only).
 * Returns message containing event which has to by explicitly acked/nacked.
 */
export declare function fetchOneRejectedDetached(amqpConnection: IAMQPConnection, eventType: string, consumerType: string): Promise<IEventDetachedMessage<IEventPayload> | null>;
export declare function bindOne<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, onEvent: (event: IEvent<TPayload>) => Promise<void>, options?: IBindOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
export declare function bindOneExpectingConfirmation<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, onEvent: (event: IEvent<TPayload>, ack: () => Promise<void>, nack: (options?: INackOptions) => void) => Promise<void>, options?: IBindOptions): Promise<() => Promise<import("../QueueSubscriber").ICloseChannel>>;
/**
 * @deprecated Use @signageos/user-domain-model/dist/Lib/CQRS/commandSynchronization instead
 */
export declare function waitSynchronized<TPayload extends IEventPayload>(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, commandId: string): Promise<{
    promise: Promise<IEvent<TPayload>>;
    cancelSubscription: () => Promise<import("../QueueSubscriber").ICloseChannel>;
}>;
export declare function purgeOne(amqpConnection: IAMQPConnection, eventType: string, consumerType: string): Promise<void>;
export declare function deleteMore(amqpConnection: IAMQPConnection, eventTypes: string[], consumerType: string): Promise<void>;
export declare function prepareMore(amqpConnection: IAMQPConnection, events: string[], consumerType: string, options?: IBindOptions): Promise<void>;
export declare function prepareMany(amqpConnection: IAMQPConnection, events: string[], domainName: string, consumerType: string, options?: IBindOptions): Promise<void>;
export declare function prepareRejected(amqpConnection: IAMQPConnection, domainName: string, consumerType: string, redeliverOptions: IRejectedRedeliverOptions, options?: IBindOptions): Promise<void>;
export declare function prepareRejectedDetached(amqpConnection: IAMQPConnection, eventType: string, consumerType: string, redeliverOptions: IRejectedRedeliverOptions, bindOptions?: IBindOptions): Promise<void>;
