"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_QUORUM_INITIAL_GROUP_SIZE = exports.REJECTED_QUEUE_PREFIX = void 0;
const _ = __importStar(require("lodash"));
const jsonHelper_1 = require("../JSON/jsonHelper");
const debug_1 = __importDefault(require("debug"));
const amqpErrors_1 = require("./amqpErrors");
const wait_1 = __importDefault(require("../Timer/wait"));
const lockedDecorator_1 = require("../Lock/lockedDecorator");
const timeout_1 = require("../Timer/timeout");
const errors_1 = require("./errors");
const ResponseProvider_1 = require("./ResponseProvider");
const debug = (0, debug_1.default)('@signageos/lib:AMQP:ChannelProvider');
const MAX_PENDING_TASKS = 100e3;
const CHANNEL_IDLE_TIMEOUT_SECONDS = 20;
const DEFAULT_PREFETCH_COUNT = 100;
exports.REJECTED_QUEUE_PREFIX = '__rejected.';
exports.DEFAULT_QUORUM_INITIAL_GROUP_SIZE = 3;
class ChannelProvider {
    constructor(amqpPool) {
        this.amqpPool = amqpPool;
        this.decodeMessageBuffer = (encodedMessageBuffer) => {
            return (encodedMessageBuffer === null || encodedMessageBuffer === void 0 ? void 0 : encodedMessageBuffer.toString()) ? JSON.parse(encodedMessageBuffer.toString(), jsonHelper_1.deserializeJSON) : null;
        };
        this.amqplibChannelMap = {};
        this.responseProviderMap = {};
    }
    getChannel(namespace, options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const amqplibConnection = yield this.getAmqplibConnection();
            let amqplibChannel;
            if (options.confirmable) {
                amqplibChannel = yield this.getAmqplibConfirmChannel(amqplibConnection, namespace);
            }
            else {
                amqplibChannel = yield this.getAmqplibChannel(amqplibConnection, namespace);
            }
            const responseProvider = this.getResponseProvider(amqplibConnection, namespace);
            const channel = {
                assertExchange: (exchangeName, type, exchangeOptions) => __awaiter(this, void 0, void 0, function* () {
                    yield amqplibChannel.assertExchange(exchangeName, type, exchangeOptions);
                }),
                send: (message, messageOptions = {}, headers = {}, exchangeName = '', routingKey) => __awaiter(this, void 0, void 0, function* () {
                    const encodedMessageBuffer = this.encodeMessageIntoBuffer(message);
                    const amqplibSendOptions = this.createAmqplibSendOptions(options, messageOptions, headers);
                    yield this.publish(amqplibChannel, exchangeName, routingKey, encodedMessageBuffer, amqplibSendOptions, options);
                }),
                sendExpectingResponse: (message, messageOptions = {}, headers = {}, exchangeName = '', routingKey, responseTimeout) => __awaiter(this, void 0, void 0, function* () {
                    const encodedMessageBuffer = this.encodeMessageIntoBuffer(message);
                    try {
                        const response = yield responseProvider.prepareResponse();
                        const amqplibSendOptions = Object.assign(Object.assign({}, this.createAmqplibSendOptions(options, messageOptions, headers)), { replyTo: response.queueName, correlationId: response.correlationId });
                        yield this.publish(amqplibChannel, exchangeName, routingKey, encodedMessageBuffer, amqplibSendOptions, options);
                        const responsePromises = [response.promise];
                        if (typeof responseTimeout !== 'undefined') {
                            const timeoutPromise = (0, timeout_1.rejectAfterTimeout)(responseTimeout);
                            responsePromises.push(timeoutPromise);
                        }
                        return yield Promise.race(responsePromises);
                    }
                    catch (error) {
                        if (error instanceof timeout_1.TimeoutError) {
                            throw new errors_1.ResponseTimeoutError();
                        }
                        else {
                            throw error;
                        }
                    }
                }),
                consumeSimple: (queueName, bindings, onMessage, consumeOptions = {}, onEnded) => __awaiter(this, void 0, void 0, function* () {
                    return yield channel.consume(queueName, bindings, (message, headers, ack, nack, fields) => __awaiter(this, void 0, void 0, function* () {
                        try {
                            const response = yield onMessage(message, headers);
                            ack();
                            return response;
                        }
                        catch (error) {
                            const requeue = !(consumeOptions.deadLetterIfRedeliveredAndErred && fields.redelivered);
                            nack({ requeue });
                            if (!consumeOptions.suppressFirstError || fields.redelivered) {
                                throw error;
                            }
                        }
                    }), consumeOptions, onEnded);
                }),
                assertRejectableQueue: (queueName, consumeOptions = {}) => __awaiter(this, void 0, void 0, function* () {
                    yield this.assertRejectableQueue(amqplibChannel, queueName, options, consumeOptions);
                }),
                consume: (queueName, bindings, onMessage, consumeOptions = {}, onEnded) => __awaiter(this, void 0, void 0, function* () {
                    const onEndedCallback = () => {
                        if (onEnded) {
                            onEnded();
                            onEnded = undefined;
                        }
                    };
                    yield amqplibChannel.prefetch(options.prefetchCount || DEFAULT_PREFETCH_COUNT);
                    yield this.assertRejectableQueue(amqplibChannel, queueName, options, consumeOptions);
                    const amqplibConsumeOptions = {};
                    if (consumeOptions.exclusiveConsumption) {
                        // almost same as exclusive, but queue can be reused later
                        const uniqueConsumerTagName = `amqp.ctag-${queueName}`;
                        amqplibConsumeOptions.consumerTag = uniqueConsumerTagName; // This will prevent have more than one consumption on queue
                    }
                    if (consumeOptions.noAck) {
                        amqplibConsumeOptions.noAck = true;
                    }
                    try {
                        const { consumerTag } = yield amqplibChannel.consume(queueName, (amqplibMessage) => __awaiter(this, void 0, void 0, function* () {
                            if (amqplibMessage === null) {
                                onEndedCallback(); // consumption canceled unexpectedly
                                amqplibChannel.removeListener('close', onEndedCallback);
                                return;
                            }
                            if (consumeOptions.redeliverDelayMs && amqplibMessage.fields.redelivered) {
                                yield (0, wait_1.default)(consumeOptions.redeliverDelayMs);
                            }
                            let sendResponse = true;
                            const message = this.decodeMessageBuffer(amqplibMessage.content);
                            const response = yield onMessage(message, amqplibMessage.properties.headers, () => {
                                if (!consumeOptions.noAck) {
                                    amqplibChannel.ack(amqplibMessage);
                                }
                            }, (nackOptions) => {
                                if (!consumeOptions.noAck) {
                                    amqplibChannel.nack(amqplibMessage, undefined, nackOptions ? nackOptions.requeue : undefined);
                                }
                                sendResponse = false;
                            }, amqplibMessage.fields);
                            if (sendResponse && consumeOptions.respond && amqplibMessage.properties.replyTo) {
                                amqplibChannel.sendToQueue(amqplibMessage.properties.replyTo, this.encodeMessageIntoBuffer(response), {
                                    correlationId: amqplibMessage.properties.correlationId,
                                });
                            }
                        }), amqplibConsumeOptions);
                        yield Promise.all(bindings.map((binding) => this.bindQueue(amqplibChannel, queueName, binding.exchangeName, binding.routingKey || '', binding.routingHeaders)));
                        amqplibChannel.once('close', onEndedCallback);
                        return () => __awaiter(this, void 0, void 0, function* () {
                            amqplibChannel.removeListener('close', onEndedCallback);
                            yield Promise.all(bindings.map((binding) => __awaiter(this, void 0, void 0, function* () {
                                if (!binding.persistent) {
                                    yield this.unbindQueue(amqplibChannel, queueName, binding.exchangeName, binding.routingKey || '', binding.routingHeaders);
                                }
                            })));
                            if ('autoDeleteDeadLetter' in consumeOptions && consumeOptions.autoDeleteDeadLetter) {
                                let message;
                                while ((message = yield amqplibChannel.get(queueName))) {
                                    // requeue=false will dead-letter message even if whole queue is deleted later
                                    amqplibChannel.nack(message, undefined, false);
                                }
                                yield amqplibChannel.deleteQueue(queueName);
                            }
                            // cancel has to be last to prevent conflicting with other consumer
                            yield amqplibChannel.cancel(consumerTag);
                        });
                    }
                    catch (error) {
                        throw new amqpErrors_1.ConsumptionError(`Could not start consumption on queue`, queueName, error);
                    }
                }),
                unbind: (queueName, binding) => __awaiter(this, void 0, void 0, function* () {
                    yield this.unbindQueue(amqplibChannel, queueName, binding.exchangeName, binding.routingKey || '', binding.routingHeaders);
                }),
                get: (queueName) => __awaiter(this, void 0, void 0, function* () {
                    const amqplibMessage = (yield amqplibChannel.get(queueName));
                    if (amqplibMessage) {
                        const message = this.decodeMessageBuffer(amqplibMessage.content);
                        return {
                            headers: amqplibMessage.properties.headers,
                            message,
                            ack: () => amqplibChannel.ack(amqplibMessage),
                            nack: (nackOptions) => amqplibChannel.nack(amqplibMessage, undefined, nackOptions ? nackOptions.requeue : undefined),
                        };
                    }
                    else {
                        return null;
                    }
                }),
                purge: (queueName) => __awaiter(this, void 0, void 0, function* () {
                    yield amqplibChannel.purgeQueue(queueName);
                }),
                delete: (queueName) => __awaiter(this, void 0, void 0, function* () {
                    yield amqplibChannel.deleteQueue(queueName);
                }),
                close: () => __awaiter(this, void 0, void 0, function* () {
                    if (options.confirmable) {
                        yield this.closeAmqplibConfirmChannel(namespace);
                    }
                    else {
                        yield this.closeAmqplibChannel(namespace);
                    }
                }),
            };
            return channel;
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            const amqplibConnection = yield this.getAmqplibConnection();
            yield this.amqpPool.destroy(amqplibConnection);
        });
    }
    encodeMessageIntoBuffer(message) {
        return Buffer.from(typeof message !== 'undefined' ? JSON.stringify(message) : '');
    }
    getAmqplibConnection() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.amqplibConnection) {
                debug('Create connection');
                const amqplibConnection = yield this.amqpPool.acquire();
                debug('Created connection');
                amqplibConnection.on('close', () => {
                    debug('Closed connection');
                    this.amqplibConnection = undefined;
                    this.amqplibChannelMap = {};
                });
                this.amqplibConnection = amqplibConnection;
            }
            return this.amqplibConnection;
        });
    }
    createAmqplibSendOptions(options, messageOptions, headers) {
        return {
            persistent: typeof messageOptions.persistent !== 'undefined' ? messageOptions.persistent : options.persistent,
            priority: messageOptions.priority,
            expiration: messageOptions.expiration,
            headers,
        };
    }
    publish(amqplibChannel, exchangeName, routingKey, encodedMessageBuffer, sendOptions, options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (options.confirmable) {
                yield new Promise((resolve, reject) => amqplibChannel.publish(exchangeName, routingKey, encodedMessageBuffer, sendOptions, (error) => error !== null ? reject(error) : resolve()));
            }
            else {
                amqplibChannel.publish(exchangeName, routingKey, encodedMessageBuffer, sendOptions);
            }
        });
    }
    getAmqplibChannel(amqplibConnection, identifier) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.getOrCreateAmqplibChannel('not_confirm-' + identifier, () => __awaiter(this, void 0, void 0, function* () {
                return yield amqplibConnection.createChannel();
            }));
        });
    }
    getAmqplibConfirmChannel(amqplibConnection, identifier) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.getOrCreateAmqplibChannel('confirm-' + identifier, () => __awaiter(this, void 0, void 0, function* () {
                return yield amqplibConnection.createConfirmChannel();
            }));
        });
    }
    closeAmqplibChannel(identifier) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.releaseAmqplibChannel('not_confirm-' + identifier);
        });
    }
    closeAmqplibConfirmChannel(identifier) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.releaseAmqplibChannel('confirm-' + identifier);
        });
    }
    getOrCreateAmqplibChannel(identifier, createChannel) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.amqplibChannelMap[identifier] === undefined) {
                debug('Create channel %s', identifier);
                const amqplibChannel = yield createChannel();
                amqplibChannel.setMaxListeners(100);
                debug('Created channel %s', identifier);
                amqplibChannel.once('error', (error) => {
                    debug('Channel error, closing immediately', identifier, error);
                    // When channel has error, it's automatically closed
                    delete this.amqplibChannelMap[identifier];
                    amqplibChannel.close().catch((closeError) => console.warn(`Could not close erred channel`, closeError));
                });
                this.amqplibChannelMap[identifier] = {
                    channel: amqplibChannel,
                    clientCount: 0,
                    closeAfterAWhile: _.debounce(() => this.tryCloseAmqplibChannelWhenUnused(identifier), CHANNEL_IDLE_TIMEOUT_SECONDS * 1000),
                };
            }
            this.amqplibChannelMap[identifier].clientCount++;
            this.amqplibChannelMap[identifier].closeAfterAWhile.cancel();
            return this.amqplibChannelMap[identifier].channel;
        });
    }
    releaseAmqplibChannel(identifier) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof this.amqplibChannelMap[identifier] !== 'undefined') {
                this.amqplibChannelMap[identifier].clientCount--;
                this.amqplibChannelMap[identifier].closeAfterAWhile();
            }
            else {
                console.log('Unexpected close channel to non-existent channel ' + identifier);
            }
        });
    }
    tryCloseAmqplibChannelWhenUnused(identifier) {
        if (typeof this.amqplibChannelMap[identifier] !== 'undefined') {
            if (this.amqplibChannelMap[identifier].clientCount <= 0) {
                const channel = this.amqplibChannelMap[identifier].channel;
                delete this.amqplibChannelMap[identifier];
                channel.close().catch((error) => console.warn(`Could not closed idle channel`, error));
            }
        }
        if (this.responseProviderMap[identifier]) {
            const responseProvider = this.responseProviderMap[identifier];
            delete this.responseProviderMap[identifier];
            responseProvider.close().catch((error) => console.warn(`Could not close idle responseProvider`, error));
        }
    }
    getResponseProvider(amqplibConnection, identifier) {
        if (!this.responseProviderMap[identifier]) {
            const responseProvider = new ResponseProvider_1.ResponseProvider(amqplibConnection, this.decodeMessageBuffer);
            this.responseProviderMap[identifier] = responseProvider;
        }
        return this.responseProviderMap[identifier];
    }
    assertRejectableQueue(amqplibChannel, queueName, queueOptions, consumeOptions) {
        return __awaiter(this, void 0, void 0, function* () {
            const extraArguments = {};
            if (consumeOptions.queueExpiresMs) {
                // x-expires is only feature of RabbitMQ, not standard amqp
                extraArguments['x-expires'] = consumeOptions.queueExpiresMs;
            }
            if (consumeOptions.messageExpiresMs) {
                // x-message-ttl is only feature of RabbitMQ, not standard amqp
                extraArguments['x-message-ttl'] = consumeOptions.messageExpiresMs;
            }
            if (consumeOptions.singleActiveConsumer) {
                // x-single-active-consumer is only feature of RabbitMQ, not standard amqp
                extraArguments['x-single-active-consumer'] = consumeOptions.singleActiveConsumer;
            }
            if (consumeOptions.queueType === 'quorum') {
                // default is classic
                extraArguments['x-queue-type'] = 'quorum';
                extraArguments['x-quorum-initial-group-size'] = exports.DEFAULT_QUORUM_INITIAL_GROUP_SIZE;
            }
            return yield amqplibChannel.assertQueue(queueName, {
                deadLetterExchange: typeof consumeOptions.deadLetterExchange !== 'undefined' ? consumeOptions.deadLetterExchange : '',
                deadLetterRoutingKey: typeof consumeOptions.deadLetterRoutingKey !== 'undefined'
                    ? consumeOptions.deadLetterRoutingKey
                    : exports.REJECTED_QUEUE_PREFIX + queueName,
                maxPriority: queueOptions.maxPriority,
                autoDelete: typeof consumeOptions.autoDelete !== 'undefined' ? consumeOptions.autoDelete : false,
                exclusive: typeof consumeOptions.exclusive !== 'undefined' ? consumeOptions.exclusive : false,
                durable: typeof consumeOptions.durable !== 'undefined' ? consumeOptions.durable : true,
                arguments: extraArguments,
            });
        });
    }
    bindQueue(amqplibChannel, queueName, exchangeName, routingKey, routingHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            if (exchangeName !== '') {
                yield amqplibChannel.bindQueue(queueName, exchangeName, routingKey, routingHeaders);
            }
        });
    }
    unbindQueue(amqplibChannel, queueName, exchangeName, routingKey, routingHeaders) {
        return __awaiter(this, void 0, void 0, function* () {
            if (exchangeName !== '') {
                yield amqplibChannel.unbindQueue(queueName, exchangeName, routingKey, routingHeaders);
            }
        });
    }
}
__decorate([
    (0, lockedDecorator_1.locked)(`AMQP.ChannelProvider.getAmqplibConnection`, { scope: 'instance', maxPending: MAX_PENDING_TASKS }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ChannelProvider.prototype, "getAmqplibConnection", null);
__decorate([
    (0, lockedDecorator_1.locked)((identifier) => `AMQP.ChannelProvider.getOrCreateAmqplibChannel.${identifier}`, {
        scope: 'instance',
        maxPending: MAX_PENDING_TASKS,
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Function]),
    __metadata("design:returntype", Promise)
], ChannelProvider.prototype, "getOrCreateAmqplibChannel", null);
exports.default = ChannelProvider;
//# sourceMappingURL=ChannelProvider.js.map