"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAutoWsSocketServer = void 0;
var wsServerFactory_1 = require("./wsServerFactory");
var wait_1 = __importDefault(require("../Timer/wait"));
var debug_1 = __importDefault(require("debug"));
var debug = (0, debug_1.default)('@signageos/lib:WebSocket:autoWsServerFactory');
function createAutoWsSocketServer(httpServer, options) {
    if (options === void 0) { options = {}; }
    var wsSocketWrapper = (0, wsServerFactory_1.createWsSocketServer)(httpServer, options);
    var resolveDisconnectedPromises = [];
    var messagesQueue = [];
    var messagesExpectingResponseQueue = [];
    var boundMessageListeners = [];
    var forceDisconnected = false;
    var socketWasConnected = false;
    var currentSocket = null;
    var wrappedSocket = {
        getDisconnectedPromise: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    return [2 /*return*/, new Promise(function (resolve) { return resolveDisconnectedPromises.push(resolve); })];
                });
            });
        },
        bindError: function (_listener) {
            // never error
            return function () { return undefined; };
        },
        bindMessage: function (event, listener) {
            var boundMessageListener = { event: event, listener: listener };
            boundMessageListeners.push(boundMessageListener);
            debug('Number of listeners', boundMessageListeners.length);
            var removeListener;
            if (currentSocket) {
                removeListener = currentSocket.bindMessage(event, listener);
            }
            return function () {
                if (removeListener) {
                    removeListener();
                }
                boundMessageListeners.splice(boundMessageListeners.indexOf(boundMessageListener), 1);
            };
        },
        getMessagePromise: function (event) {
            var _this = this;
            return new Promise(function (resolve) {
                var unbindMessage = _this.bindMessage(event, function (message) {
                    unbindMessage();
                    resolve(message);
                });
            });
        },
        sendMessage: function (event, payload) {
            return __awaiter(this, void 0, void 0, function () {
                var error_1, error2_1;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!currentSocket) return [3 /*break*/, 9];
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 8]);
                            return [4 /*yield*/, Promise.race([currentSocket.sendMessage(event, payload), (0, wait_1.default)(5e3).then(function () { return Promise.reject("Send message timed-out"); })])];
                        case 2:
                            _a.sent();
                            return [3 /*break*/, 8];
                        case 3:
                            error_1 = _a.sent();
                            debug('Failed to send message', event, payload, error_1);
                            messagesQueue.push({ event: event, payload: payload });
                            debug('Number of messages in queue', messagesQueue.length);
                            _a.label = 4;
                        case 4:
                            _a.trys.push([4, 6, , 7]);
                            return [4 /*yield*/, currentSocket.disconnect()];
                        case 5:
                            _a.sent();
                            return [3 /*break*/, 7];
                        case 6:
                            error2_1 = _a.sent();
                            debug('nothing when already disconnected', event, payload, error2_1);
                            return [3 /*break*/, 7];
                        case 7: return [3 /*break*/, 8];
                        case 8: return [3 /*break*/, 10];
                        case 9:
                            debug('Requeued message', event, payload);
                            messagesQueue.push({ event: event, payload: payload });
                            debug('Number of messages in queue', messagesQueue.length);
                            _a.label = 10;
                        case 10: return [2 /*return*/];
                    }
                });
            });
        },
        sendMessageExpectingResponse: function (event, payload) {
            return __awaiter(this, void 0, void 0, function () {
                var error_2, error2_2;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!currentSocket) return [3 /*break*/, 9];
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 8]);
                            return [4 /*yield*/, Promise.race([
                                    currentSocket.sendMessageExpectingResponse(event, payload),
                                    (0, wait_1.default)(5e3).then(function () { return Promise.reject("Send message expecting response timed-out"); }),
                                ])];
                        case 2:
                            _a.sent();
                            return [3 /*break*/, 8];
                        case 3:
                            error_2 = _a.sent();
                            debug('Failed to send message expecting response', event, payload, error_2);
                            messagesExpectingResponseQueue.push({ event: event, payload: payload });
                            debug('Number of messages in queue expecting response', messagesExpectingResponseQueue.length);
                            _a.label = 4;
                        case 4:
                            _a.trys.push([4, 6, , 7]);
                            return [4 /*yield*/, currentSocket.disconnect()];
                        case 5:
                            _a.sent();
                            return [3 /*break*/, 7];
                        case 6:
                            error2_2 = _a.sent();
                            debug('nothing when already disconnected', event, payload, error2_2);
                            return [3 /*break*/, 7];
                        case 7: return [3 /*break*/, 8];
                        case 8: return [3 /*break*/, 10];
                        case 9:
                            debug('Requeued message expecting response', event, payload);
                            messagesExpectingResponseQueue.push({ event: event, payload: payload });
                            debug('Number of messages in queue expecting response', messagesExpectingResponseQueue.length);
                            _a.label = 10;
                        case 10: return [2 /*return*/];
                    }
                });
            });
        },
        disconnect: function (code, reason) {
            if (code === void 0) { code = 1000; }
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (forceDisconnected) {
                                throw new Error("The socket is already disconnected");
                            }
                            forceDisconnected = true;
                            if (!currentSocket) return [3 /*break*/, 2];
                            return [4 /*yield*/, currentSocket.disconnect(code, reason)];
                        case 1:
                            _a.sent();
                            return [3 /*break*/, 3];
                        case 2:
                            resolveDisconnectedPromises.forEach(function (resolve) { return resolve({ code: code, reason: reason }); });
                            _a.label = 3;
                        case 3: return [2 /*return*/];
                    }
                });
            });
        },
        drain: function () {
            if (!forceDisconnected) {
                throw new Error("Disconnect socket first");
            }
        },
        get hostname() {
            return currentSocket === null || currentSocket === void 0 ? void 0 : currentSocket.hostname;
        },
        get path() {
            return currentSocket === null || currentSocket === void 0 ? void 0 : currentSocket.path;
        },
        get headers() {
            return currentSocket === null || currentSocket === void 0 ? void 0 : currentSocket.headers;
        },
    };
    function reinitiateSocket() {
        return __awaiter(this, void 0, void 0, function () {
            var _i, boundMessageListeners_1, boundMessageListener, message;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (currentSocket) {
                            for (_i = 0, boundMessageListeners_1 = boundMessageListeners; _i < boundMessageListeners_1.length; _i++) {
                                boundMessageListener = boundMessageListeners_1[_i];
                                currentSocket.bindMessage(boundMessageListener.event, boundMessageListener.listener);
                            }
                        }
                        // Wait a bit before queued messages are resend to allow client bind message events
                        return [4 /*yield*/, (0, wait_1.default)(20)];
                    case 1:
                        // Wait a bit before queued messages are resend to allow client bind message events
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        if (!((message = messagesQueue.shift()) && currentSocket !== null)) return [3 /*break*/, 4];
                        return [4 /*yield*/, wrappedSocket.sendMessage(message.event, message.payload)];
                    case 3:
                        _a.sent();
                        return [3 /*break*/, 2];
                    case 4:
                        debug('Number of messages in queue after repeat', messagesQueue.length);
                        _a.label = 5;
                    case 5:
                        if (!((message = messagesExpectingResponseQueue.shift()) && currentSocket !== null)) return [3 /*break*/, 7];
                        return [4 /*yield*/, wrappedSocket.sendMessageExpectingResponse(message.event, message.payload)];
                    case 6:
                        _a.sent();
                        return [3 /*break*/, 5];
                    case 7:
                        debug('Number of messages in queue expecting response after repeat', messagesExpectingResponseQueue.length);
                        return [2 /*return*/];
                }
            });
        });
    }
    return {
        server: {
            bindConnection: function (serverListener) {
                var _this = this;
                wsSocketWrapper.server.bindConnection(function (socket) {
                    if (currentSocket !== null) {
                        throw new Error("The socket already connected");
                    }
                    forceDisconnected = false;
                    currentSocket = socket;
                    socket.getDisconnectedPromise().then(function (closeData) {
                        currentSocket = null;
                        socket.drain();
                        if (forceDisconnected) {
                            socketWasConnected = false;
                            resolveDisconnectedPromises.forEach(function (resolve) { return resolve(closeData); });
                            resolveDisconnectedPromises = [];
                            messagesQueue = [];
                            messagesExpectingResponseQueue = [];
                            boundMessageListeners = [];
                        }
                    });
                    socket.bindError(function (error) { return __awaiter(_this, void 0, void 0, function () {
                        var _1;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    console.error(error);
                                    _a.label = 1;
                                case 1:
                                    _a.trys.push([1, 3, , 4]);
                                    return [4 /*yield*/, socket.disconnect()];
                                case 2:
                                    _a.sent();
                                    return [3 /*break*/, 4];
                                case 3:
                                    _1 = _a.sent();
                                    return [3 /*break*/, 4];
                                case 4: return [2 /*return*/];
                            }
                        });
                    }); });
                    reinitiateSocket();
                    if (!socketWasConnected) {
                        serverListener(wrappedSocket);
                        socketWasConnected = true;
                    }
                });
            },
        },
        listen: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, wsSocketWrapper.listen()];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
        close: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, wsSocketWrapper.close()];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
    };
}
exports.createAutoWsSocketServer = createAutoWsSocketServer;
//# sourceMappingURL=autoWsServerFactory.js.map