"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createProgressiveWait = void 0;
var wait_1 = __importDefault(require("./wait"));
/**
 * Creates a progressive wait function that can be used to wait for a period of time,
 * and then progressively increase the wait time by a multiplier.
 *
 * @param initialTimeoutMs The initial timeout in milliseconds.
 * @param progressiveMultiplier The multiplier to use when increasing the timeout.
 * @param maxTimeoutMs The maximum timeout in milliseconds.
 * @example of usage:
 * const wait = createProgressiveWait(1000);
 * await wait(); // waits for 1000ms
 * await wait(); // waits for 2000ms
 * await wait(); // waits for 4000ms
 * await wait(); // waits for 8000ms
 * await wait(); // waits for 10000ms
 *
 * const wait = createProgressiveWait(1000, 3);
 * await wait(); // waits for 1000ms
 * await wait(); // waits for 3000ms
 * await wait(); // waits for 9000ms
 * await wait(); // waits for 10000ms
 */
var createProgressiveWait = function (initialTimeoutMs, progressiveMultiplier, maxTimeoutMs) {
    if (progressiveMultiplier === void 0) { progressiveMultiplier = 2; }
    if (maxTimeoutMs === void 0) { maxTimeoutMs = initialTimeoutMs * 10; }
    var currentTimeoutMs = initialTimeoutMs;
    return {
        wait: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, (0, wait_1.default)(currentTimeoutMs)];
                        case 1:
                            _a.sent();
                            currentTimeoutMs = this.getNextTimeoutMs();
                            return [2 /*return*/];
                    }
                });
            });
        },
        reset: function () {
            currentTimeoutMs = initialTimeoutMs;
        },
        getCurrentTimeoutMs: function () {
            return currentTimeoutMs;
        },
        getNextTimeoutMs: function () {
            return Math.min(currentTimeoutMs * progressiveMultiplier, maxTimeoutMs);
        },
    };
};
exports.createProgressiveWait = createProgressiveWait;
//# sourceMappingURL=progressiveWait.js.map