"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmClient = void 0;
var child_process_1 = require("child_process");
var util_1 = require("util");
var path = __importStar(require("path"));
var async_lock_1 = __importDefault(require("async-lock"));
var fs = __importStar(require("fs-extra"));
var debug_1 = __importDefault(require("debug"));
var debugDecorator_1 = require("../Debug/debugDecorator");
var NpmCredentialsProvider_1 = require("./NpmCredentialsProvider");
var DEBUG_NAMESPACE = '@signageos/lib:Npm:NpmClient';
var logDebug = (0, debug_1.default)(DEBUG_NAMESPACE);
var execAsync = (0, util_1.promisify)(child_process_1.exec);
var NpmClient = /** @class */ (function () {
    function NpmClient(credentialsProvider) {
        if (credentialsProvider === void 0) { credentialsProvider = (0, NpmCredentialsProvider_1.createDefaultNpmCredentialsProvider)(); }
        this.credentialsProvider = credentialsProvider;
        this.lock = new async_lock_1.default();
    }
    NpmClient.prototype.getPackageVersions = function (packageName) {
        return __awaiter(this, void 0, void 0, function () {
            var result, resultParsed;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.execNpmCommand({
                            command: 'info',
                            args: [packageName, 'versions', '--json'],
                        })];
                    case 1:
                        result = _a.sent();
                        resultParsed = JSON.parse(result);
                        if (typeof resultParsed === 'string') {
                            return [2 /*return*/, [resultParsed]];
                        }
                        else {
                            return [2 /*return*/, resultParsed];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    NpmClient.prototype.downloadPackage = function (_a) {
        var packageName = _a.packageName, downloadPath = _a.downloadPath, version = _a.version;
        return __awaiter(this, void 0, void 0, function () {
            var lockKey;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        lockKey = version ? "".concat(packageName, ".").concat(version) : packageName;
                        return [4 /*yield*/, this.lock.acquire(lockKey, function () { return __awaiter(_this, void 0, void 0, function () {
                                var packageWithVersion, fileName, srcPath, destPath;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            packageWithVersion = version ? "".concat(packageName, "@").concat(version) : packageName;
                                            return [4 /*yield*/, this.execNpmCommand({
                                                    command: 'pack',
                                                    args: [packageWithVersion],
                                                })];
                                        case 1:
                                            fileName = _a.sent();
                                            srcPath = path.join(process.cwd(), fileName.trim());
                                            destPath = path.join(downloadPath, fileName.trim());
                                            return [4 /*yield*/, fs.move(srcPath, destPath)];
                                        case 2:
                                            _a.sent();
                                            return [2 /*return*/, destPath];
                                    }
                                });
                            }); })];
                    case 1: return [2 /*return*/, _b.sent()];
                }
            });
        });
    };
    NpmClient.prototype.execNpmCommand = function (_a) {
        var command = _a.command, args = _a.args;
        return __awaiter(this, void 0, void 0, function () {
            var credentials, argsString, fullCommand, _b, stdout, stderr;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, this.credentialsProvider()];
                    case 1:
                        credentials = _c.sent();
                        argsString = args ? args.join(' ') : '';
                        fullCommand = "npm ".concat(command, " ").concat(argsString);
                        return [4 /*yield*/, execAsync(fullCommand, {
                                env: {
                                    PATH: process.env.PATH,
                                    NPM_REGISTRY_HOST: credentials.host,
                                    NPM_REGISTRY_URL: credentials.url,
                                    NPM_AUTH_TOKEN: credentials.authToken,
                                },
                            })];
                    case 2:
                        _b = _c.sent(), stdout = _b.stdout, stderr = _b.stderr;
                        if (stdout) {
                            logDebug("exec command: ".concat(fullCommand), stdout);
                        }
                        if (stderr) {
                            logDebug("exec command: ".concat(fullCommand), stderr);
                        }
                        return [2 /*return*/, stdout];
                }
            });
        });
    };
    __decorate([
        (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
    ], NpmClient.prototype, "getPackageVersions", null);
    __decorate([
        (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], NpmClient.prototype, "downloadPackage", null);
    return NpmClient;
}());
exports.NpmClient = NpmClient;
//# sourceMappingURL=NpmClient.js.map