"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.POSTGRE_DB_LABEL = void 0;
var dateTimeFactory_1 = require("../../DateTime/dateTimeFactory");
var lodash_1 = require("lodash");
exports.POSTGRE_DB_LABEL = 'postgreDB';
function default_1(postgreSqlConnection) {
    return __awaiter(this, void 0, void 0, function () {
        var databaseRequestMoment, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    databaseRequestMoment = (0, dateTimeFactory_1.now)();
                    return [4 /*yield*/, postgreSqlConnection.connection.task(function (db) {
                            return __awaiter(this, void 0, void 0, function () {
                                var transferBytes, transferData, databaseTransferedMoment, responseTime, speed, dataTransfer;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, db.one('SELECT 1')];
                                        case 1:
                                            _a.sent();
                                            transferBytes = Math.pow(2, 15);
                                            transferData = (0, lodash_1.times)(transferBytes / 2, (0, lodash_1.constant)('0')).join('');
                                            return [4 /*yield*/, db.one('SELECT $1', [transferData])];
                                        case 2:
                                            _a.sent();
                                            databaseTransferedMoment = (0, dateTimeFactory_1.now)();
                                            responseTime = databaseTransferedMoment.diff(databaseRequestMoment).valueOf();
                                            speed = (0, lodash_1.round)((transferBytes / responseTime) * 1e3);
                                            dataTransfer = {
                                                speed: speed,
                                                speedHumanized: humanizeUnit(speed, 1024) + 'B/s',
                                            };
                                            return [2 /*return*/, dataTransfer];
                                    }
                                });
                            });
                        })];
                case 1:
                    response = _a.sent();
                    return [2 /*return*/, response];
            }
        });
    });
}
exports.default = default_1;
function humanizeUnit(amount, baseStep, precision) {
    if (precision === void 0) { precision = 0; }
    var units = ['', 'K', 'M', 'G', 'T', 'P'];
    var unitIndex = 0;
    while (amount > baseStep && typeof units[unitIndex] !== 'undefined') {
        amount = amount / baseStep;
        unitIndex++;
    }
    return (0, lodash_1.round)(amount, precision) + String.fromCharCode(160) + units[unitIndex];
}
//# sourceMappingURL=postgreSqlStatusCheck.js.map