/**
 * Globally recommended value for token encryption iterations value.
 */
export declare const DEFAULT_ITERATIONS = 10000;
/**
 * Old value for old tokens where was too much iterations and encrypting was too slow (not usable)
 * @deprecated Use DEFAULT_ITERATIONS value instead which is compromise in security of token and speed
 */
export declare const OBSOLETE_ITERATIONS = 100000;
/**
 * Globally recommended function to encrypt tokens.
 * Use default iterations value if possible. Only for special cases or for obsolete tokens is used different.
 */
export declare function encryptToken(plainToken: string, salt: string, iterations?: number): Promise<string>;
